/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.device.service.MultiplexDeviceListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;

public class DeviceListeners
extends EscObject
implements MultiplexDeviceListener {
    private DeviceListener[] objects;

    public DeviceListeners(DeviceListener currentObject, DeviceListener newObject) {
        if (currentObject instanceof DeviceListeners) {
            DeviceListeners currentMulticaster = (DeviceListeners)currentObject;
            DeviceListener[] oldList = currentMulticaster.getObjects();
            this.objects = new DeviceListener[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new DeviceListener[]{currentObject, newObject};
        }
    }

    public DeviceListeners(DeviceListener[] objects) {
        this.setObjects(objects);
    }

    public static DeviceListener add(DeviceListener currentObject, DeviceListener newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new DeviceListeners(currentObject, newObject);
    }

    public static DeviceListener remove(DeviceListener currentObject, DeviceListener removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof DeviceListeners) {
            return ((DeviceListeners)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public void channelChanged(DeviceService source, Object timestamp, ChannelService channel, int newState, int oldState) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                DeviceListener obj = this.objects[i];
                if (obj instanceof MultiplexDeviceListener) {
                    MultiplexDeviceListener listener = (MultiplexDeviceListener)obj;
                    listener.channelChanged(source, timestamp, channel, newState, oldState);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public void controlChanged(DeviceService container, Object timestamp, ControlService control, int code) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].controlChanged(container, timestamp, control, code);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public void deviceChanged(DeviceService source, Object timestamp, int newState, int oldState) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].deviceChanged(source, timestamp, newState, oldState);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].errorOccurred(source, timestamp, data);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public DeviceListener[] getObjects() {
        return this.objects;
    }

    protected DeviceListener remove(DeviceListener removeHandler) {
        DeviceListener[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        DeviceListener[] newList = new DeviceListener[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new DeviceListeners(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    private void setObjects(DeviceListener[] objects) {
        this.objects = objects;
    }
}

