/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import org.eclipse.soda.dk.measurement.DataMeasurement;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.service.MultiplexSignalListener;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class SignalMeasurement
extends DataMeasurement
implements MultiplexSignalListener {
    private SignalService signal;

    public SignalMeasurement(String key, Object value, UnitsService units, TransformService transform, SignalService signal) {
        super(key, value, units, transform);
        this.setSignal(signal);
    }

    public SignalMeasurement(String key, SignalService signal) {
        this(key, null, null, null, signal);
    }

    public SignalMeasurement(String key, TransformService transform, SignalService signal) {
        this(key, null, null, transform, signal);
    }

    public SignalMeasurement(String key, UnitsService units, TransformService transform, SignalService signal) {
        this(key, null, units, transform, signal);
    }

    protected void finalize() throws Throwable {
        if (this.signal != null) {
            this.signal.removeSignalListener((SignalListener)this);
            this.signal = null;
        }
    }

    public SignalService getSignal() {
        return this.signal;
    }

    protected void setSignal(SignalService signal) {
        if (this.signal != null) {
            this.signal.removeSignalListener((SignalListener)this);
        }
        this.signal = signal;
        if (signal != null) {
            this.signal.addSignalListener((SignalListener)this);
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, ChannelService channel, Object data) {
        this.setRawValue(channel, data, timestamp);
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        this.signalOccurred(source, timestamp, null, data);
    }
}

