/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskManager;
import org.eclipse.soda.dk.signal.service.SignalService;

public abstract class AbstractTask
extends EscObject
implements ITask {
    protected static final Map EMPTY_RESULT = new HashMap();
    private ITaskManager taskManager;
    private Set taskListeners;
    private int state;
    private Byte stateLock = new Byte(0);
    protected Byte listenerLock = new Byte(0);
    protected Byte timerLock = new Byte(0);
    private Timer taskTimer;
    private Object taskOwner;
    private TaskListenerRemover listenerRemover;

    protected AbstractTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(ITaskListener listener) {
        Byte by = this.listenerLock;
        synchronized (by) {
            if (this.taskListeners == null) {
                this.taskListeners = Collections.synchronizedSet(new HashSet());
            }
            this.taskListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getState() {
        Byte by = this.stateLock;
        synchronized (by) {
            return this.state;
        }
    }

    public Set getTaskListeners() {
        return this.taskListeners;
    }

    protected boolean isRemoveListenerRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListener(String taskName, int status, Object result) {
        this.preNotifyListener(taskName, status, result);
        if (status == 0 || status == 1 || status == 2 || status == 4) {
            this.setState(0);
        }
        Byte by = this.listenerLock;
        synchronized (by) {
            if (this.taskListeners != null) {
                Iterator listeners = this.taskListeners.iterator();
                while (listeners.hasNext()) {
                    ITaskListener taskListener = (ITaskListener)listeners.next();
                    taskListener.taskNotice(taskName, status, result);
                }
            }
        }
    }

    protected void preNotifyListener(String taskName, int status, Object result) {
    }

    public void abort() {
        this.notifyListener(this.getTaskName(), 4, "Task abort:" + this.getTaskName());
    }

    private TaskListenerRemover getListenerRemover() {
        if (this.listenerRemover == null) {
            this.listenerRemover = new TaskListenerRemover();
        }
        return this.listenerRemover;
    }

    public ITaskManager getTaskManager() {
        return this.taskManager;
    }

    public Object getTaskOwner() {
        return this.taskOwner;
    }

    private Timer getTimer() {
        if (this.taskTimer == null) {
            this.taskTimer = new Timer();
        }
        return this.taskTimer;
    }

    public boolean isResponseExpected(SignalService source, Object timestamp, Object data) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(ITaskListener listener) {
        if (!this.isRemoveListenerRequired()) {
            return;
        }
        TaskListenerRemover listenerRemover = this.getListenerRemover();
        listenerRemover.setListener(listener);
        if (!listenerRemover.isAlive()) {
            listenerRemover.start();
        } else {
            Byte by = this.listenerLock;
            synchronized (by) {
                this.listenerLock.notify();
            }
        }
    }

    protected void removeTaskListenerNoThread(ITaskListener listener) {
        if (this.taskListeners != null) {
            this.taskListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Byte by = this.listenerLock;
        synchronized (by) {
            if (this.taskListeners != null) {
                this.taskListeners.clear();
            }
        }
        if (this.getTaskManager() != null) {
            this.getTaskManager().removeTask(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int state) {
        Byte by = this.stateLock;
        synchronized (by) {
            this.state = state;
        }
    }

    public void setTaskListeners(Set taskListeners) {
        this.taskListeners = taskListeners;
    }

    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void setTaskOwner(Object taskOwner) {
        this.taskOwner = taskOwner;
    }

    public void start() {
        if (this.getTaskManager() != null) {
            this.getTaskManager().addTask(this);
        } else {
            this.launchTask();
        }
    }

    public void start(ITaskManager taskManager) {
        this.setTaskManager(taskManager);
        taskManager.addTask(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTimer(long millis) {
        if (millis <= 0L) {
            return;
        }
        Timer taskTimer = this.getTimer();
        if (taskTimer.isAlive()) {
            if (taskTimer.getTimerState() == 1) {
                this.stopTimer();
            }
            taskTimer.setMillis(millis);
            Byte by = this.timerLock;
            synchronized (by) {
                this.timerLock.notify();
            }
        } else {
            taskTimer.setMillis(millis);
            taskTimer.start();
        }
    }

    protected void stopTimer() {
        if (this.getTimer() != null && this.getTimer().isAlive()) {
            this.getTimer().interrupt();
        }
    }

    protected void timeOutOccurred() {
        this.notifyListener(this.getTaskName(), 2, EMPTY_RESULT);
    }

    class TaskListenerRemover
    extends Thread {
        private ITaskListener listener;

        TaskListenerRemover() {
        }

        private ITaskListener getListener() {
            return this.listener;
        }

        public void run() {
            Byte by = AbstractTask.this.listenerLock;
            synchronized (by) {
                while (true) {
                    if (this.getListener() != null) {
                        AbstractTask.this.removeTaskListenerNoThread(this.getListener());
                        this.setListener(null);
                    }
                    try {
                        AbstractTask.this.listenerLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void setListener(ITaskListener listener) {
            this.listener = listener;
        }
    }

    class Timer
    extends Thread {
        public static final int STANDBY = 0;
        public static final int RUNNING = 1;
        public static final int WAITING = 2;
        private long millis;
        private int state;

        public Timer() {
            this(0L);
        }

        public Timer(long millis) {
            this.millis = millis;
            this.setTimerState(0);
        }

        public int getTimerState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    this.setTimerState(1);
                    Thread.sleep(this.millis);
                    AbstractTask.this.timeOutOccurred();
                }
                catch (InterruptedException interruptedException) {}
                try {
                    Byte by = AbstractTask.this.timerLock;
                    synchronized (by) {
                        this.setTimerState(2);
                        AbstractTask.this.timerLock.wait();
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void setMillis(long millis) {
            this.millis = millis;
        }

        public void setTimerState(int state) {
            this.state = state;
        }
    }
}

