/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.transport;

import org.eclipse.soda.dk.message.SimpleResponseMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;

public class EpcglobalLlrpMessage
extends SimpleResponseMessage {
    public EpcglobalLlrpMessage() {
    }

    public EpcglobalLlrpMessage(byte[] data) {
        super(data);
    }

    public EpcglobalLlrpMessage(byte[] data, int offset, int length) {
        super(data, offset, length);
    }

    public EpcglobalLlrpMessage(byte[] data, MessageService sentMessage) {
        super(data, sentMessage);
    }

    public EpcglobalLlrpMessage(String data) {
        super(data);
    }

    public String toString() {
        byte[] bytes = this.getBytes();
        int length = bytes.length;
        if (length < 10) {
            return super.toString();
        }
        StringBuffer buffer = new StringBuffer(1024);
        try {
            this.toString(bytes, buffer);
        }
        catch (RuntimeException runtimeException) {
            buffer.append("raw:");
            Nls.formatHexBytesOnly((byte[])bytes, (int)0, (int)bytes.length, (StringBuffer)buffer);
        }
        MessageService sentMessage = this.getSentMessage();
        if (sentMessage != null) {
            buffer.append(" <- ");
            buffer.append(sentMessage);
        }
        return buffer.toString();
    }

    public void toString(byte[] bytes, StringBuffer buffer) {
        int length = bytes.length;
        buffer.append('{');
        Nls.formatHexBytesOnly((byte[])bytes, (int)0, (int)2, (StringBuffer)buffer);
        int type = ((bytes[0] & 3) << 8) + (bytes[1] & 0xFF);
        buffer.append('(');
        buffer.append(type);
        buffer.append(')');
        buffer.append(' ');
        Nls.formatHexBytesOnly((byte[])bytes, (int)2, (int)4, (StringBuffer)buffer);
        buffer.append(' ');
        Nls.formatHexBytesOnly((byte[])bytes, (int)6, (int)4, (StringBuffer)buffer);
        int offset = 0;
        this.toStringParameter(bytes, offset + 10, length - 10, buffer);
        buffer.append('}');
    }

    public void toStringParameter(byte[] bytes, int offset, int length, StringBuffer buffer) {
        if (length > 0) {
            buffer.append(' ');
            int toffset = offset;
            int type = ((bytes[toffset] & 3) << 8) + (bytes[toffset + 1] & 0xFF);
            Nls.formatHexBytesOnly((byte[])bytes, (int)toffset, (int)2, (StringBuffer)buffer);
            buffer.append('(');
            buffer.append(type);
            buffer.append(')');
            buffer.append(' ');
            int parameterLength = ((bytes[toffset += 2] & 0xFF) << 8) + (bytes[toffset + 1] & 0xFF);
            if (parameterLength <= 4) {
                buffer.append("raw:");
                Nls.formatHexBytesOnly((byte[])bytes, (int)offset, (int)length, (StringBuffer)buffer);
                return;
            }
            Nls.formatHexBytesOnly((byte[])bytes, (int)toffset, (int)2, (StringBuffer)buffer);
            buffer.append(' ');
            Nls.formatHexBytesOnly((byte[])bytes, (int)(toffset += 2), (int)(parameterLength - 4), (StringBuffer)buffer);
            toffset = offset + parameterLength;
            this.toStringParameter(bytes, toffset, length - parameterLength, buffer);
        }
    }
}

