/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.adapter;

import java.util.Map;
import org.eclipse.soda.dk.adapter.Adapter;
import org.eclipse.soda.dk.generic.adapter.service.GenericBarcodeListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericBarcodeListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericGpioListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericGpioListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericInventoryListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericInventoryListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericWriteListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericWriteListenerService;

public class GenericAdapter
extends Adapter
implements GenericInventoryListenerService,
GenericWriteListenerService,
GenericBarcodeListenerService,
GenericGpioListenerService {
    GenericInventoryListener inventoryListener;
    GenericWriteListener writeListener;
    GenericGpioListener gpioListener;
    GenericBarcodeListener barcodeListener;

    protected void handleBarcodeEvent(String barcode, Map barcodeData) {
        if (this.barcodeListener != null) {
            this.barcodeListener.receiveBarcodeEvent(barcode, barcodeData);
        }
    }

    protected void handleInputEvent(int inputPin, boolean state) {
        if (this.gpioListener != null) {
            this.gpioListener.receiveInputEvent(inputPin, state);
        }
    }

    protected void handleTagEvent(String tagId, Map tagData) {
        if (this.inventoryListener != null) {
            this.inventoryListener.receiveTagEvent(tagId, tagData);
        }
    }

    protected void handleWriteEvent(String tagId, Map tagData) {
        if (this.writeListener != null) {
            this.writeListener.receiveWriteEvent(tagId, tagData);
        }
    }

    protected void handleWriteEvent(String tagId, String operationId, Map tagData) {
        if (this.writeListener != null) {
            this.writeListener.receiveWriteEvent(tagId, operationId, tagData);
        }
    }

    public void setBarcodeListener(GenericBarcodeListener barcodeListener) {
        this.barcodeListener = barcodeListener;
    }

    public void setGpioListener(GenericGpioListener gpioListener) {
        this.gpioListener = gpioListener;
    }

    public void setInventoryListener(GenericInventoryListener inventoryListener) {
        this.inventoryListener = inventoryListener;
    }

    public void setWriteListener(GenericWriteListener writeListener) {
        this.writeListener = writeListener;
    }
}

