/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gpio.profile.test.agent;

import java.io.IOException;
import java.util.Map;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAbstractTestCase;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileTestAgent;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testagent.TestAgent;

public class GpioProfileAnalogInputTestCase
extends GpioProfileAbstractTestCase {
    static /* synthetic */ Class class$0;

    public GpioProfileAnalogInputTestCase(String name) {
        super(name);
    }

    public static void main(String[] arguments) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAnalogInputTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForProfileStart("GpioProfile");
    }

    public void test000_AnalogInputValues() throws InterruptedException, IOException {
        int inputCount = Integer.parseInt(this.getMeasurement(this.gpioProfileServiceAnalogInputCountExternalKey).toString());
        if (inputCount < 1) {
            return;
        }
        String inputProperty = this.getString("expected.analog.input.value", "");
        long[] lowerRange = new long[inputCount];
        long[] upperRange = new long[inputCount];
        this.setAnalogInputRanges(inputProperty, lowerRange, upperRange);
        GpioProfileAnalogInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7514))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceAnalogInputExternalKey);
        int i = 0;
        while (i < realValue.size()) {
            long keyValue = Long.parseLong(realValue.get("ai" + (i + 1)).toString());
            Object[] inputAndValue = new Object[]{new Integer(i + 1), new Long(keyValue)};
            GpioProfileAnalogInputTestCase.assertTrue((String)Nls.format((String)GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7515)), (Object[])inputAndValue), (boolean)this.analogInputWithinRange(keyValue, lowerRange[i], upperRange[i]));
            ++i;
        }
    }

    public void test001_AnalogInputValuesNotInRange() throws InterruptedException, IOException {
        int inputCount = Integer.parseInt(this.getMeasurement(this.gpioProfileServiceAnalogInputCountExternalKey).toString());
        if (inputCount < 1) {
            return;
        }
        String inputProperty = this.getString("expected.analog.input.value", "");
        long[] lowerRange = new long[inputCount];
        long[] upperRange = new long[inputCount];
        this.setAnalogInputRanges(inputProperty, lowerRange, upperRange);
        GpioProfileAnalogInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7519))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceAnalogInputExternalKey);
        int i = 0;
        while (i < realValue.size()) {
            long keyValue = Long.parseLong(realValue.get("ai" + (i + 1)).toString());
            Object[] inputAndValue = new Object[]{new Integer(i + 1), new Long(keyValue)};
            GpioProfileAnalogInputTestCase.assertFalse((String)Nls.format((String)GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7520)), (Object[])inputAndValue), (boolean)this.analogInputWithinRange(keyValue, lowerRange[i], upperRange[i]));
            ++i;
        }
    }
}

