/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.matrix.lcd.simulator.view;

import java.awt.Image;
import java.awt.Label;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.AbstractPanelWithBackground;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.LcdDisplayPanelConstants;

public class LcdDisplayPanel
extends AbstractPanelWithBackground
implements LcdDisplayPanelConstants {
    private static final long serialVersionUID = 3233038403608893124L;
    private Image backlightOnImage;
    private Image backlightOffImage;
    private Label firstLine;
    private Label secondLine;
    private StringBuffer buffer;
    private int cursorPosition;

    public LcdDisplayPanel() {
        this.setSize(352, 69);
        this.populate();
        this.initialize();
    }

    public void clearText() {
        this.setBufferContents(EMPTY_BUFFER_CONTENTS);
        this.populateLabels();
    }

    public void decrementCursorPosition() {
        this.setCursorPosition((this.getCursorPosition() - 1) % DISPLAY_SIZE);
    }

    protected Image getBacklightOffImage() {
        return this.backlightOffImage;
    }

    protected Image getBacklightOnImage() {
        return this.backlightOnImage;
    }

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected int getCursorPosition() {
        return this.cursorPosition;
    }

    public void incrementCursorPosition() {
        this.setCursorPosition((this.getCursorPosition() + 1) % DISPLAY_SIZE);
    }

    protected void initialize() {
        this.setBacklightOnImage(this.loadImage(ON_SRC));
        this.setBacklightOffImage(this.loadImage(OFF_SRC));
        this.setCurrentImage(this.getBacklightOffImage());
        this.firstLine.setBackground(LCD_UNLIT_COLOR);
        this.secondLine.setBackground(LCD_UNLIT_COLOR);
        this.setCursorPosition(0);
        this.setBuffer(new StringBuffer(24288));
        this.setBufferContents(EMPTY_BUFFER_CONTENTS);
        this.populateLabels();
    }

    protected boolean isPrintableCharacter(byte c) {
        return !Character.isISOControl((char)c);
    }

    protected void populate() {
        this.setLayout(null);
        this.firstLine = new Label();
        this.add(this.firstLine);
        this.firstLine.setLocation(23, 13);
        this.firstLine.setSize(306, 25);
        this.firstLine.setFont(MONO);
        this.secondLine = new Label();
        this.add(this.secondLine);
        this.secondLine.setLocation(23, 38);
        this.secondLine.setSize(306, 25);
        this.secondLine.setFont(MONO);
    }

    protected void populateLabels() {
        this.firstLine.setText(this.getBuffer().substring(0, 20));
        this.secondLine.setText(this.getBuffer().substring(20, 40));
    }

    public void printCharacter(byte charToPrint) {
        this.printCharacter(charToPrint, true);
    }

    protected void printCharacter(byte charToPrint, boolean refresh) {
        String toPrint = this.isPrintableCharacter(charToPrint) ? new String(new byte[]{charToPrint}) : " ";
        this.buffer.replace(this.getCursorPosition(), this.getCursorPosition() + 1, toPrint);
        this.incrementCursorPosition();
        if (refresh) {
            this.populateLabels();
        }
    }

    public void printString(String string) {
        int i = 0;
        while (i < string.length() - 1) {
            this.printCharacter((byte)string.charAt(i), false);
            ++i;
        }
        this.printCharacter((byte)string.charAt(i), true);
    }

    public void sendCursorToPosition(int x, int y) {
        if (x >= 2 || y >= DISPLAY_SIZE >> 1) {
            this.sendCursorToPosition(0, 0);
        }
        this.setCursorPosition(x + y * (DISPLAY_SIZE >> 1));
    }

    protected void setBacklightOffImage(Image image) {
        this.backlightOffImage = image;
    }

    protected void setBacklightOnImage(Image image) {
        this.backlightOnImage = image;
    }

    protected void setBuffer(StringBuffer bs) {
        this.buffer = bs;
    }

    protected void setBufferContents(StringBuffer bs) {
        this.getBuffer().replace(0, this.getBuffer().length(), bs.toString());
    }

    protected void setCursorPosition(int i) {
        this.cursorPosition = i;
    }

    public void showDefaultText() {
        this.setBufferContents(DEFAULT_BUFFER_CONTENTS);
        this.populateLabels();
    }

    public void turnOffBacklight() {
        this.setCurrentImage(this.getBacklightOffImage());
        this.firstLine.setBackground(LCD_UNLIT_COLOR);
        this.secondLine.setBackground(LCD_UNLIT_COLOR);
        this.refresh();
    }

    public void turnOnBacklight() {
        this.setCurrentImage(this.getBacklightOnImage());
        this.firstLine.setBackground(LCD_LIT_COLOR);
        this.secondLine.setBackground(LCD_LIT_COLOR);
        this.refresh();
    }
}

