/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.platform.validation.test.checker;

import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.platform.validation.test.agent.PlatformValidationTestAgent;
import org.eclipse.soda.dk.platform.validation.test.checker.DeclarationInfo;
import org.eclipse.soda.dk.platform.validation.test.checker.FieldInfo;
import org.eclipse.soda.dk.platform.validation.test.checker.MethodInfo;

public class ClassInfo
extends DeclarationInfo {
    private static final long serialVersionUID = -7831024535733389781L;
    private String superClassName;
    private String[] interfaceNames;
    private FieldInfo[] fields;
    private MethodInfo[] methods;
    private Integer innerClassAccessFlags;

    public ClassInfo() {
    }

    public ClassInfo(String name, int accessFlags, String superClassName, String[] interfaceNames) {
        super(name, accessFlags);
        this.superClassName = superClassName;
        this.interfaceNames = interfaceNames;
    }

    public FieldInfo[] getFields() {
        return this.fields;
    }

    public Integer getInnerClassAccessFlags() {
        return this.innerClassAccessFlags;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public Class[] getInterfaces() throws ClassNotFoundException {
        Class[] interfaces = new Class[this.interfaceNames.length];
        int i = 0;
        while (i < interfaces.length) {
            interfaces[i] = Class.forName(this.interfaceNames[i]);
            ++i;
        }
        return interfaces;
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public int getModifiers() {
        return this.innerClassAccessFlags == null ? this.getAccessFlags() : this.innerClassAccessFlags.intValue();
    }

    public Class getSuperClass() throws ClassNotFoundException {
        return this.superClassName == null ? null : Class.forName(this.superClassName);
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public boolean isInterface() {
        return (this.getAccessFlags() | 0x200) != 0;
    }

    public void setFields(FieldInfo[] fields) {
        this.fields = fields;
    }

    public void setInnerClassAccessFlags(Integer innerClassAccessFlags) {
        this.innerClassAccessFlags = innerClassAccessFlags;
    }

    public void setMethods(MethodInfo[] methods) {
        this.methods = methods;
    }

    public String toString() {
        return Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7429)), (Object)this.getName());
    }
}

