/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.benchmark.servlet;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.rfid.inventory.benchmark.profile.service.RfidInventoryBenchmarkProfileService;
import org.eclipse.soda.dk.rfid.inventory.benchmark.servlet.IRfidInventoryBenchmarkReader;
import org.eclipse.soda.dk.rfid.inventory.benchmark.servlet.RfidInventoryBenchmarkReader;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.record.interfaces.ServiceDetecterListener;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RfidInventoryBenchmarkServletConsole {
    private BundleContext bundleContext;
    private String currentPrefix;
    private IServiceDetecter llrpInventoryBenchmarkServiceDetecter;
    private ServiceDetecterListener serviceDetecterListener;
    private Map readerList;
    private NotificationService notificationService;

    public RfidInventoryBenchmarkServletConsole(BundleContext bundleContext, NotificationService notificationService) {
        this.bundleContext = bundleContext;
        this.notificationService = notificationService;
        this.activate();
    }

    protected void activate() {
        IServiceDetecter rfidInventoryServiceDetecter = this.getRfidInventoryBenchmarkServiceDetecter();
        rfidInventoryServiceDetecter.addServiceDetecterListener(this.getServiceDetecterListener());
        rfidInventoryServiceDetecter.acquire();
    }

    protected void addReader(String prefix) {
        if (!this.getReaderList().containsKey(prefix)) {
            RfidInventoryBenchmarkReader reader = new RfidInventoryBenchmarkReader(prefix, this.getNotificationService());
            this.getReaderList().put(prefix, reader);
        }
        this.setCurrentPrefix((String)this.getReaderList().keySet().iterator().next());
    }

    public void changeBenchmarkState(boolean state) {
        IRfidInventoryBenchmarkReader reader = this.getReader(this.getCurrentPrefix());
        if (reader == null) {
            return;
        }
        reader.setBenchmarking(state);
    }

    protected void clearBenchmarkReports() {
        IRfidInventoryBenchmarkReader reader = this.getReader(this.getCurrentPrefix());
        if (reader == null) {
            return;
        }
        reader.clearBenchmarkReports();
    }

    public boolean containsPrefix(String prefix) {
        return this.getReaderList().keySet().contains(prefix);
    }

    private IServiceDetecter createRfidInventoryBenchmarkServiceDetecter() {
        FactoryUtility utility = FactoryUtility.getInstance();
        BundleContext context = this.getBundleContext();
        IServiceDetecter detecter = utility.createServiceDetecter(context, "org.eclipse.soda.dk.rfid.inventory.benchmark.profile.service.RfidInventoryBenchmarkProfileService");
        return detecter;
    }

    private ServiceDetecterListener createServiceDetecterListener() {
        return new ServiceDetecterListener(){

            public void serviceAdded(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
                String readerPrefix = (String)serviceReference.getProperty("prefix");
                if (service instanceof RfidInventoryBenchmarkProfileService) {
                    RfidInventoryBenchmarkServletConsole.this.addReader(readerPrefix);
                }
            }

            public void serviceRemoved(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
            }
        };
    }

    public void displayDetailReport(DeviceServletContext context, String prefix, int serialNum) {
        IRfidInventoryBenchmarkReader reader = this.getReader(prefix);
        if (reader == null) {
            context.addEntity("message", (Object)("Reader " + prefix + " doesn't exist."));
            context.template("error");
            return;
        }
        reader.displayBenchmarkDetailReports(context, serialNum);
    }

    protected void displayReaderList(DeviceServletContext context) {
        context.template("reader_list_begin");
        Iterator readers = this.getReaderList().keySet().iterator();
        while (readers.hasNext()) {
            String prefix = (String)readers.next();
            context.addEntity("ReaderId", (Object)prefix);
            context.addEntity("Selected", (Object)(prefix.equals(this.getCurrentPrefix()) ? "selected=\"selected\"" : ""));
            context.template("reader_list_entry");
        }
        context.template("reader_list_end");
    }

    protected void getBenchmarkReport_ajax(DeviceServletContext context) {
        IRfidInventoryBenchmarkReader reader = this.getReader(this.getCurrentPrefix());
        if (reader == null) {
            return;
        }
        reader.getBenchmarkReport_ajax(context);
    }

    public boolean getBenchmarkState() {
        IRfidInventoryBenchmarkReader reader = this.getReader(this.getCurrentPrefix());
        if (reader == null) {
            return false;
        }
        return reader.isBenchmarkEnabled();
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getCurrentPrefix() {
        return this.currentPrefix;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    private IRfidInventoryBenchmarkReader getReader(String prefix) {
        return (IRfidInventoryBenchmarkReader)this.getReaderList().get(prefix);
    }

    protected Map getReaderList() {
        if (this.readerList == null) {
            this.readerList = new TreeMap();
        }
        return this.readerList;
    }

    public IServiceDetecter getRfidInventoryBenchmarkServiceDetecter() {
        if (this.llrpInventoryBenchmarkServiceDetecter == null) {
            this.llrpInventoryBenchmarkServiceDetecter = this.createRfidInventoryBenchmarkServiceDetecter();
        }
        return this.llrpInventoryBenchmarkServiceDetecter;
    }

    public ServiceDetecterListener getServiceDetecterListener() {
        if (this.serviceDetecterListener == null) {
            this.serviceDetecterListener = this.createServiceDetecterListener();
        }
        return this.serviceDetecterListener;
    }

    public boolean isTagreadStarted() {
        IRfidInventoryBenchmarkReader reader = this.getReader(this.getCurrentPrefix());
        if (reader == null) {
            return false;
        }
        return reader.isTagreadStarted();
    }

    public void saveDetailToFile(String readerId, int serialNum, String fileName, String comment, DeviceServletContext context) throws IOException {
        PrintWriter file = new PrintWriter(new FileWriter(fileName));
        context.setWriter(file);
        context.addEntity("comment", (Object)comment);
        context.template("detail_file_begin");
        IRfidInventoryBenchmarkReader reader = this.getReader(readerId);
        context.addEntity("Reader", (Object)reader.getPrefix());
        context.addEntity("serialnum", (Object)String.valueOf(serialNum));
        context.template("detail_file_head");
        List reports = reader.getBenchmarkDetailReports(serialNum);
        int i = 0;
        while (i < reports.size()) {
            Map report = (Map)reports.get(i);
            context.addEntity("serialnum", (Object)String.valueOf(i + 1));
            context.addEntities(report);
            context.template("detail_file_entry");
            ++i;
        }
        context.template("benchmark_file_tail");
        file.close();
    }

    public void saveToFile(String fileName, String comment, DeviceServletContext context) throws IOException {
        PrintWriter file = new PrintWriter(new FileWriter(fileName));
        context.setWriter(file);
        context.addEntity("comment", (Object)comment);
        context.template("benchmark_file_begin");
        IRfidInventoryBenchmarkReader reader = this.getReader(this.getCurrentPrefix());
        context.addEntity("reader", (Object)reader.getPrefix());
        context.template("benchmark_file_head");
        List reports = reader.getBenchmarkReports();
        int i = 0;
        while (i < reports.size()) {
            Map report = (Map)reports.get(i);
            context.addEntities(report);
            context.template("benchmark_file_entry");
            ++i;
        }
        context.template("benchmark_file_tail");
        file.close();
    }

    public void setCurrentPrefix(String prefix) {
        if (prefix.equals(this.currentPrefix)) {
            return;
        }
        this.currentPrefix = prefix;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    protected boolean startBenchmarkRuns(int cycles, long duration, long delay) {
        IRfidInventoryBenchmarkReader reader = this.getReader(this.getCurrentPrefix());
        if (reader == null) {
            return false;
        }
        System.gc();
        return reader.startBenchmarkRuns(cycles, duration, delay);
    }

    protected void stopBenchmarkRuns() {
        IRfidInventoryBenchmarkReader reader = this.getReader(this.getCurrentPrefix());
        if (reader == null) {
            return;
        }
        reader.stopBenchmarkRuns();
    }
}

