/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.comm.bundle;

import org.eclipse.soda.dk.comm.internal.Library;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private String parseBundleList(String rawList, String bundleFile) {
        String result = null;
        int i = rawList.indexOf(bundleFile);
        if (i != -1) {
            int j = rawList.lastIndexOf(44, i);
            int k = rawList.lastIndexOf("file:", i);
            result = k != -1 ? rawList.substring(k + 5, i + bundleFile.length()) : rawList.substring(j + 1, i + bundleFile.length());
        }
        return result;
    }

    private String parseInstall(String rawInstall) {
        int i = rawInstall.indexOf("file:");
        String result = rawInstall.substring(i + 5);
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    private String parseLoc(String rawLoc) {
        int i = rawLoc.indexOf("file:");
        String result = rawLoc.substring(i + 5);
        if (rawLoc.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public void start(BundleContext arg0) throws Exception {
        String bundle_loc = arg0.getBundle().getLocation();
        if (bundle_loc.startsWith("http")) {
            Library.setBundlepath("http", bundle_loc);
        } else {
            String bundle_file_name = this.parseLoc(bundle_loc);
            String bundle_install = this.parseInstall(System.getProperty("osgi.install.area"));
            String bundle_path = this.parseBundleList(System.getProperty("osgi.bundles"), bundle_file_name);
            if (bundle_path == null || bundle_path.length() == bundle_file_name.length()) {
                bundle_path = String.valueOf(bundle_install) + bundle_file_name;
            }
            Library.setBundlepath("file", bundle_path);
        }
    }

    public void stop(BundleContext arg0) throws Exception {
    }
}

