/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.serial.connection;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import org.eclipse.soda.dk.connection.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.serial.connection.SerialPortListener;
import org.eclipse.soda.dk.serial.connection.service.SerialConnectionService;

public class SerialConnection
extends StreamConnection
implements ConnectionService,
SerialConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.serial.connection.SerialConnection";
    private static final int[] DATABITS_TABLE = new int[]{-1, -1, -1, -1, -1, 5, 6, 7, 8};
    private static final int[] PARITY_TABLE;
    private static final String PREFIX;
    private static final int[] STOP_TABLE;
    protected static final char[] TOSTRING_NAME;
    private SerialPort port = null;
    private String portName = null;
    private long receivedTotalTimeout = 1000L;
    private SerialPortListener serialPortListener = null;

    static {
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 3;
        PARITY_TABLE = nArray;
        PREFIX = EscObject.getStaticString((String)"serialconnection.prefix", (String)"COM");
        STOP_TABLE = new int[]{1, 3, 2};
        TOSTRING_NAME = "SerialConnection[".toCharArray();
    }

    public SerialConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public SerialConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public SerialConnection(int comport, int baudrate, int databits, int parity, int stopbits, int hardwareflowcontrol, int softwareflowcontrol, int readtotaltimeout, int readintervaltimeout, int writetotaltimeout) throws IllegalArgumentException {
        Hashtable<String, Integer> table = new Hashtable<String, Integer>(23);
        table.put("comport", SerialConnection.createInteger((int)comport));
        if (baudrate != 19200) {
            table.put("baudrate", SerialConnection.createInteger((int)baudrate));
        }
        if (databits != 8) {
            table.put("databits", SerialConnection.createInteger((int)databits));
        }
        if (parity != 0) {
            table.put("parity", SerialConnection.createInteger((int)parity));
        }
        if (stopbits != 0) {
            table.put("stopbits", SerialConnection.createInteger((int)stopbits));
        }
        if (hardwareflowcontrol != 0) {
            table.put("hardwareflowcontrol", SerialConnection.createInteger((int)hardwareflowcontrol));
        }
        if (softwareflowcontrol != 0) {
            table.put("softwareflowcontrol", SerialConnection.createInteger((int)softwareflowcontrol));
        }
        if ((long)readtotaltimeout != 1000L) {
            table.put("readtotaltimeout", SerialConnection.createInteger((int)readtotaltimeout));
        }
        if ((long)readintervaltimeout != 100L) {
            table.put("readintervaltimeout", SerialConnection.createInteger((int)readintervaltimeout));
        }
        if ((long)writetotaltimeout != 100L) {
            table.put("writetotaltimeout", SerialConnection.createInteger((int)writetotaltimeout));
        }
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public SerialConnection(int comport, int baudrate, int databits, int parity, int stopbits, int hardwareflowcontrol, int softwareflowcontrol, long readtotaltimeout, long readintervaltimeout, long writetotaltimeout) throws IllegalArgumentException {
        Hashtable<String, Number> table = new Hashtable<String, Number>(23);
        table.put("comport", SerialConnection.createInteger((int)comport));
        if (baudrate != 19200) {
            table.put("baudrate", SerialConnection.createInteger((int)baudrate));
        }
        if (databits != 8) {
            table.put("databits", SerialConnection.createInteger((int)databits));
        }
        if (parity != 0) {
            table.put("parity", SerialConnection.createInteger((int)parity));
        }
        if (stopbits != 0) {
            table.put("stopbits", SerialConnection.createInteger((int)stopbits));
        }
        if (hardwareflowcontrol != 0) {
            table.put("hardwareflowcontrol", SerialConnection.createInteger((int)hardwareflowcontrol));
        }
        if (softwareflowcontrol != 0) {
            table.put("softwareflowcontrol", SerialConnection.createInteger((int)softwareflowcontrol));
        }
        if (readtotaltimeout != 1000L) {
            table.put("readtotaltimeout", SerialConnection.createLong((long)readtotaltimeout));
        }
        if (readintervaltimeout != 100L) {
            table.put("readintervaltimeout", SerialConnection.createLong((long)readintervaltimeout));
        }
        if (writetotaltimeout != 100L) {
            table.put("writetotaltimeout", SerialConnection.createLong((long)writetotaltimeout));
        }
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public SerialConnection(String portName, int baudRate, int dataBits, int parity, int stopBits, int hardwareFlowControl, int softwareFlowControl, int readTotalTimeout, int readIntervalTimeout, int writeTotalTimeout) throws IllegalArgumentException {
        this.portName = portName;
        Hashtable<String, Number> table = new Hashtable<String, Number>(23);
        table.put("baudrate", SerialConnection.createInteger((int)baudRate));
        table.put("databits", SerialConnection.createInteger((int)dataBits));
        table.put("parity", SerialConnection.createInteger((int)parity));
        table.put("stopbits", SerialConnection.createInteger((int)stopBits));
        table.put("hardwareflowcontrol", SerialConnection.createInteger((int)hardwareFlowControl));
        table.put("softwareflowcontrol", SerialConnection.createInteger((int)softwareFlowControl));
        table.put("readtotaltimeout", SerialConnection.createNumber((long)readTotalTimeout));
        table.put("readintervaltimeout", SerialConnection.createNumber((long)readIntervalTimeout));
        table.put("writetotaltimeout", SerialConnection.createNumber((long)writeTotalTimeout));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public static String getPortName(int portNumber) {
        return String.valueOf(PREFIX) + String.valueOf(portNumber);
    }

    public void changeBaudRate(int baudRate) throws RuntimeException {
        this.getConfigurationService().getProperties().put("baudrate", SerialConnection.createInteger((int)baudRate));
        try {
            this.port.setSerialPortParams(this.getInt("baudrate", 19200), DATABITS_TABLE[this.getInt("databits", 8)], STOP_TABLE[this.getInt("stopbits", 0)], PARITY_TABLE[this.getInt("parity", 0)]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.port != null) {
            this.port.removeEventListener();
            Exception exception = null;
            try {
                this.port.close();
            }
            catch (Exception e) {
                exception = e;
            }
            this.port = null;
            this.handleError(exception, 1002, this.toString());
        }
    }

    public String getOutputName() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(super.getOutputName());
        buffer.append(',');
        buffer.append(this.getPortName());
        return buffer.toString();
    }

    public String getPortName() {
        if (this.portName == null) {
            int portNumber = this.getInt("comport", 1);
            this.portName = SerialConnection.getPortName(portNumber);
        }
        return this.portName;
    }

    public long getReceivedTotalTimeout() {
        return this.receivedTotalTimeout;
    }

    public String getType() {
        return "serial";
    }

    public synchronized void open() throws IOException {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier(this.getPortName());
            CommPort commPort = commPortIdentifier.open(this.toString(), 1000);
            if (commPort instanceof SerialPort) {
                boolean hardware;
                boolean software;
                this.port = (SerialPort)commPort;
                this.port.setSerialPortParams(this.getInt("baudrate", 19200), DATABITS_TABLE[this.getInt("databits", 8)], STOP_TABLE[this.getInt("stopbits", 0)], PARITY_TABLE[this.getInt("parity", 0)]);
                int flowControl = 0;
                boolean bl = software = this.getInt("softwareflowcontrol", 0) == 1;
                if (software) {
                    flowControl = flowControl | 4 | 8;
                }
                boolean bl2 = hardware = this.getInt("hardwareflowcontrol", 0) == 1;
                if (hardware) {
                    flowControl = flowControl | 1 | 2;
                }
                if (flowControl != 0) {
                    this.port.setFlowControlMode(flowControl);
                }
                this.setReceivedTotalTimeout(this.getLong("readtotaltimeout", 1000L));
                this.port.enableReceiveTimeout((int)this.getReceivedTotalTimeout());
                this.serialPortListener = new SerialPortListener(this.port);
                this.setInputStream(this.port.getInputStream());
                this.setOutputStream(this.port.getOutputStream());
                super.open();
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes) throws IOException {
        int count = super.read(bytes);
        if (count == 0) {
            SerialPortListener serialPortListener = this.serialPortListener;
            synchronized (serialPortListener) {
                try {
                    this.serialPortListener.wait(this.getReceivedTotalTimeout());
                }
                catch (Exception exception) {}
            }
            count = super.read(bytes);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int count = super.read(bytes, offset, length);
        if (count == 0) {
            SerialPortListener serialPortListener = this.serialPortListener;
            synchronized (serialPortListener) {
                try {
                    this.serialPortListener.wait(this.getReceivedTotalTimeout());
                }
                catch (Exception exception) {}
            }
            count = super.read(bytes, offset, length);
        }
        return count;
    }

    public void setDTR(boolean dtr) {
        if (this.port != null) {
            this.port.setDTR(dtr);
        }
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setRTS(boolean rts) {
        if (this.port != null) {
            this.port.setRTS(rts);
        }
    }

    public void setReceivedTotalTimeout(long timeout) {
        this.receivedTotalTimeout = timeout;
    }
}

