var testmgr = new Object();

testmgr.HttpRequest = function() {
    this.req = null;
    this.text = null;
    this.url = null;
    this.onload = this.defaultOnload;
    this.onerror = this.defaultError;
}

testmgr.READYSTATE_UNITITIALIZED=0;
testmgr.READYSTATE_LOADING=1;
testmgr.READYSTATE_LOADED=2;
testmgr.READYSTATE_INTERACTIVE=3;
testmgr.READYSTATE_COMPLETE=4;

testmgr.HttpRequest.prototype = {
    post:function(url) {
        if (window.XMLHttpRequest) {
        	this.req = new XMLHttpRequest();
        } else {
        	if (window.ActiveXObject) {
				try {
					this.req = new ActiveXObject("Msxml2.XMLHTTP")
				} catch (e) {
			    	this.req = new ActiveXObject("Microsoft.XMLHTTP")
				}
			} else {
				alert("Browser does not support AJAX.");
			}
        }
        if (this.req) {
            try {
                this.setUrl(url);
                var loader = this;
                this.req.onreadystatechange = function() { loader.onReadyStateHandler.call(loader); }
                this.req.open('POST', url, true);
                this.req.send(null);
            } catch(err) {
                this.onerror.call(this);
            }
        }
    },

    onReadyStateHandler:function() {
        var ready = this.req.readyState;
        if(ready == testmgr.READYSTATE_COMPLETE) {
            if(this.req.status == 200 || this.req.status == 0) {
                this.setText(this.req.responseText);
                this.onload.call(this);
            } else {
                this.onerror.call(this);
            }
        }
    },

    defaultOnload:function() {
    	// No action
    },

    defaultError:function() {
        alert("Error communicating with test manager."
            + "\nURL: " + this.url
            + "\nreadyState: " + this.req.readyState
            + "\nstatus: " + this.req.status
            + "\nheaders: " + this.req.getAllResponseHeaders());
    },

    setResponseHandler:function(handler) { this.onload = handler; },
    setErrorHandler:function(handler) { this.onerror = handler; },
    setUrl:function(url) { this.url = url; },
    getUrl:function() { return this.url; },
    setText:function(text) { this.text = text; },
    getText:function() { return this.text; }
}
