/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.servlet;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testmanager.service.ScriptRunListenerService;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.eclipse.soda.dk.testmanager.service.TestStatisticsService;
import org.eclipse.soda.dk.testmanager.servlet.DeviceTestManagerServlet;

public class TestReport
implements ScriptRunListenerService,
TestRunListenerService {
    private List events = new ArrayList();
    private int eventIndex;
    private boolean finished;

    private static void appendAttribute(StringBuffer detail, String name, Object value) {
        if (value != null) {
            detail.append(name);
            detail.append(": ");
            detail.append(value);
            detail.append('\n');
        }
    }

    private void addErrorEvent(String message, String trace) {
        this.addEvent(true, message, trace);
    }

    private void addEvent(String reportLine) {
        this.addEvent(false, reportLine, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(boolean error, String message, String detail) {
        Event event = new Event();
        event.timestamp = new Date();
        event.error = error;
        event.message = message;
        event.detail = detail;
        List list = this.events;
        synchronized (list) {
            this.events.add(event);
            this.events.notify();
        }
    }

    public void scriptActionEnded(String actionId, String message) {
        Object[] parms = new Object[]{actionId, message};
        this.addEvent(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7256)), (Object[])parms));
    }

    public void scriptActionError(String actionId, String message, String detail) {
        Object[] parms = new Object[]{actionId, message};
        this.addErrorEvent(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7257)), (Object[])parms), detail);
    }

    public void scriptActionInfo(String actionId, String message) {
        this.addEvent(message);
    }

    public void scriptActionStarted(String parentActionId, String actionId, String message) {
        Object[] parms = new Object[]{actionId, message};
        this.addEvent(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7258)), (Object[])parms));
    }

    public void scriptRunEnded(TestStatisticsService testStatistics) {
        int testCount;
        int testActionCount;
        int configActionCount;
        this.finished = true;
        boolean error = false;
        StringBuffer trace = new StringBuffer();
        int scriptErrorCount = testStatistics.getCount("TEST_SCRIPT_ERROR_COUNT");
        if (scriptErrorCount > 0) {
            error = true;
        }
        if ((configActionCount = testStatistics.getCount("CONFIGURATION_COUNT")) > 0) {
            int configActionErrorCount = testStatistics.getCount("CONFIGURATION_ERROR_COUNT");
            if (configActionErrorCount > 0) {
                error = true;
            }
            Object[] parms = new Object[]{new Integer(configActionCount), new Integer(configActionErrorCount)};
            trace.append(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7259)), (Object[])parms));
        }
        if ((testActionCount = testStatistics.getCount("TEST_COUNT")) > 0) {
            int testActionErrorCount = testStatistics.getCount("TEST_ERROR_COUNT");
            if (testActionErrorCount > 0) {
                error = true;
            }
            Object[] parms = new Object[]{new Integer(testActionCount), new Integer(testActionErrorCount)};
            trace.append(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7260)), (Object[])parms));
        }
        if ((testCount = testStatistics.getCount("TEST_CASE_COUNT")) > 0) {
            int testErrorCount = testStatistics.getCount("TEST_CASE_ERROR_COUNT");
            int testFailedCount = testStatistics.getCount("TEST_CASE_FAILED_COUNT");
            if (testErrorCount > 0 || testFailedCount > 0) {
                error = true;
            }
            Object[] parms = new Object[]{new Integer(testCount), new Integer(testErrorCount), new Integer(testFailedCount)};
            trace.append(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7261)), (Object[])parms));
        }
        this.addEvent(error, DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7262)), trace.toString());
    }

    public void scriptRunError(String message, String trace) {
        Object[] parms = new Object[]{message};
        this.addErrorEvent(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7263)), (Object[])parms), trace);
    }

    public void scriptRunStarted(TestScriptService script) {
        Object title = script.getAttributes().get("title");
        Object version = script.getAttributes().get("version");
        Object vendor = script.getAttributes().get("vendor");
        Object description = script.getAttributes().get("description");
        Object url = script.getAttributes().get("url");
        if (title == null) {
            title = DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7264));
        }
        StringBuffer detail = new StringBuffer();
        TestReport.appendAttribute(detail, "version", version);
        TestReport.appendAttribute(detail, "vendor", vendor);
        TestReport.appendAttribute(detail, "description", description);
        TestReport.appendAttribute(detail, "url", url);
        Object[] parms = new Object[]{title};
        this.addEvent(false, Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7265)), (Object[])parms), detail.toString());
    }

    public synchronized void testEnded(String runId, String testName) {
    }

    public synchronized void testError(String runId, String testName, String trace) {
        Object[] parms = new Object[]{testName, runId};
        this.addErrorEvent(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7266)), (Object[])parms), trace);
    }

    public synchronized void testFailed(String runId, String testName, String trace) {
        Object[] parms = new Object[]{testName, runId};
        this.addErrorEvent(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7267)), (Object[])parms), trace);
    }

    public synchronized void testRunEnded(String runId) {
    }

    public synchronized void testRunError(String runId, String message, String detail) {
        Object[] parms = new Object[]{message, runId};
        this.addErrorEvent(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7268)), (Object[])parms), detail);
    }

    public void testRunStarted(String actionId, String runId) {
    }

    public synchronized void testStarted(String runId, String testName) {
        Object[] parms = new Object[]{testName, runId};
        this.addEvent(Nls.format((String)DeviceTestManagerServlet.DefaultResourceBundle.getString(Integer.toString(7269)), (Object[])parms));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event waitForNextEvent() throws InterruptedException {
        List list = this.events;
        synchronized (list) {
            while (this.eventIndex == this.events.size() && !this.finished) {
                this.events.wait();
            }
            if (this.eventIndex < this.events.size()) {
                return (Event)this.events.get(this.eventIndex++);
            }
        }
        return null;
    }

    public static class Event {
        public Date timestamp;
        public boolean error;
        public String message;
        public String detail;
    }
}

