/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.test;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.record.interfaces.ServiceDetecterListener;
import org.eclipse.soda.sat.junit.util.ValueHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceDetecterTestCase
extends AbstractServiceTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static Test suite() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.ServiceDetecterTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ServiceDetecterTestCase(String name) {
        super(name);
    }

    private IServiceDetecter createServiceDetecter(String name) {
        BundleContext context = this.getBundleContext();
        IServiceDetecter detecter = AbstractSatTestCase.FACTORY.createServiceDetecter(context, name);
        return detecter;
    }

    public void test_acquire() {
        IServiceDetecter detecter = this.createServiceDetecter(TestService1.SERVICE_NAME);
        BundleContext context = this.getBundleContext();
        TestServiceImplementation service = new TestServiceImplementation();
        ServiceRegistration registration = context.registerService(TestService1.SERVICE_NAME, (Object)service, null);
        final ValueHolder addedHolder = ValueHolder.nullValue();
        final ValueHolder removedHolder = ValueHolder.nullValue();
        TestServiceImplementation expected = null;
        Object actual = addedHolder.getValue();
        Assert.assertSame(expected, (Object)actual);
        ServiceDetecterListener listener = new ServiceDetecterListener(){

            public void serviceAdded(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
                addedHolder.setValue(service);
            }

            public void serviceRemoved(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
                removedHolder.setValue(service);
            }
        };
        detecter.addServiceDetecterListener(listener);
        detecter.acquire();
        expected = service;
        actual = addedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        addedHolder.setNull();
        detecter.acquire();
        expected = null;
        actual = addedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        actual = removedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        registration.unregister();
        expected = service;
        actual = removedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        detecter.removeServiceDetecterListener(listener);
        detecter.release();
    }

    public void test_getName() {
        IServiceDetecter detecter = this.createServiceDetecter(TestService1.SERVICE_NAME);
        String expected = TestService1.SERVICE_NAME;
        String actual = detecter.getName();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getServiceReferences() {
        BundleContext context = this.getBundleContext();
        TestServiceImplementation service1 = new TestServiceImplementation();
        ServiceRegistration registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        ServiceReference reference1 = registration1.getReference();
        TestServiceImplementation service2 = new TestServiceImplementation();
        ServiceRegistration registration2 = context.registerService(TestService1.SERVICE_NAME, (Object)service2, null);
        ServiceReference reference2 = registration2.getReference();
        IServiceDetecter detecter = this.createServiceDetecter(TestService1.SERVICE_NAME);
        detecter.acquire();
        List references = detecter.getServiceReferences();
        int expected = 2;
        int actual = references.size();
        Assert.assertEquals((int)expected, (int)actual);
        boolean exists = references.contains(reference1);
        Assert.assertTrue((boolean)exists);
        exists = references.contains(reference2);
        Assert.assertTrue((boolean)exists);
        registration2.unregister();
        registration1.unregister();
        detecter.release();
    }

    public void test_getServices() {
        BundleContext context = this.getBundleContext();
        TestServiceImplementation service1 = new TestServiceImplementation();
        TestServiceImplementation service2 = new TestServiceImplementation();
        ServiceRegistration registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        ServiceRegistration registration2 = context.registerService(TestService1.SERVICE_NAME, (Object)service2, null);
        IServiceDetecter detecter = this.createServiceDetecter(TestService1.SERVICE_NAME);
        detecter.acquire();
        List services = detecter.getServices();
        int expected = 2;
        int actual = services.size();
        Assert.assertEquals((int)expected, (int)actual);
        boolean exists = services.contains(service1);
        Assert.assertTrue((boolean)exists);
        exists = services.contains(service2);
        Assert.assertTrue((boolean)exists);
        registration2.unregister();
        registration1.unregister();
        detecter.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_getServicesReferencesWithFilter() throws InvalidSyntaxException {
        IServiceDetecter detecter;
        ServiceRegistration registration2;
        ServiceRegistration registration1;
        block8: {
            TestServiceImplementation service1 = new TestServiceImplementation();
            TestServiceImplementation service2 = new TestServiceImplementation();
            TestServiceImplementation service3 = new TestServiceImplementation();
            Hashtable<String, String> serviceProperties1 = new Hashtable<String, String>(11);
            Hashtable<String, String> serviceProperties2 = new Hashtable<String, String>(11);
            Hashtable<String, String> serviceProperties3 = new Hashtable<String, String>(11);
            String vendorKey = "vendor";
            String ibmVendor = "IBM";
            String otiVendor = "OTI";
            String xyzVendor = "XYZ";
            ((Dictionary)serviceProperties1).put(vendorKey, ibmVendor);
            ((Dictionary)serviceProperties2).put(vendorKey, otiVendor);
            ((Dictionary)serviceProperties3).put(vendorKey, ibmVendor);
            BundleContext context = this.getBundleContext();
            registration1 = null;
            registration2 = null;
            ServiceRegistration registration3 = null;
            detecter = null;
            try {
                registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, serviceProperties1);
                registration2 = context.registerService(TestService1.SERVICE_NAME, (Object)service2, serviceProperties2);
                registration3 = context.registerService(TestService1.SERVICE_NAME, (Object)service3, serviceProperties3);
                detecter = this.createServiceDetecter(TestService1.SERVICE_NAME);
                detecter.acquire();
                String filter = String.valueOf('(') + vendorKey + '=' + ibmVendor + ')';
                List services = detecter.getServiceReferences(filter);
                int expectedSize = 2;
                int actualSize = services.size();
                Assert.assertEquals((int)expectedSize, (int)actualSize);
                String expectedVendor = ibmVendor;
                ServiceReference reference = (ServiceReference)services.get(0);
                Object actualVendor = reference.getProperty(vendorKey);
                Assert.assertEquals((Object)expectedVendor, (Object)actualVendor);
                reference = (ServiceReference)services.get(1);
                actualVendor = reference.getProperty(vendorKey);
                Assert.assertEquals((Object)expectedVendor, (Object)actualVendor);
                filter = String.valueOf('(') + vendorKey + '=' + otiVendor + ')';
                services = detecter.getServiceReferences(filter);
                expectedSize = 1;
                actualSize = services.size();
                Assert.assertEquals((int)expectedSize, (int)actualSize);
                expectedVendor = otiVendor;
                reference = (ServiceReference)services.get(0);
                actualVendor = reference.getProperty(vendorKey);
                Assert.assertEquals((Object)expectedVendor, (Object)actualVendor);
                filter = String.valueOf('(') + vendorKey + '=' + xyzVendor + ')';
                services = detecter.getServiceReferences(filter);
                expectedSize = 0;
                actualSize = services.size();
                Assert.assertEquals((int)expectedSize, (int)actualSize);
            }
            catch (Throwable throwable) {
                Object var23_24 = null;
                if (registration3 != null) {
                    registration3.unregister();
                }
                if (registration2 != null) {
                    registration2.unregister();
                }
                if (registration1 != null) {
                    registration1.unregister();
                }
                if (detecter == null) throw throwable;
                detecter.release();
                throw throwable;
            }
            {
                Object var23_25 = null;
                if (registration3 == null) break block8;
            }
            registration3.unregister();
        }
        if (registration2 != null) {
            registration2.unregister();
        }
        if (registration1 != null) {
            registration1.unregister();
        }
        if (detecter == null) return;
        detecter.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_getServicesWithFilter() throws InvalidSyntaxException {
        IServiceDetecter detecter;
        ServiceRegistration registration2;
        ServiceRegistration registration1;
        block8: {
            TestServiceImplementation service1 = new TestServiceImplementation();
            TestServiceImplementation service2 = new TestServiceImplementation();
            TestServiceImplementation service3 = new TestServiceImplementation();
            Hashtable<String, String> serviceProperties1 = new Hashtable<String, String>(11);
            Hashtable<String, String> serviceProperties2 = new Hashtable<String, String>(11);
            Hashtable<String, String> serviceProperties3 = new Hashtable<String, String>(11);
            String vendor = "vendor";
            String ibmVendor = "IBM";
            String otiVendor = "OTI";
            String xyzVendor = "XYZ";
            ((Dictionary)serviceProperties1).put(vendor, ibmVendor);
            ((Dictionary)serviceProperties2).put(vendor, otiVendor);
            ((Dictionary)serviceProperties3).put(vendor, ibmVendor);
            BundleContext context = this.getBundleContext();
            registration1 = null;
            registration2 = null;
            ServiceRegistration registration3 = null;
            detecter = null;
            try {
                registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, serviceProperties1);
                registration2 = context.registerService(TestService1.SERVICE_NAME, (Object)service2, serviceProperties2);
                registration3 = context.registerService(TestService1.SERVICE_NAME, (Object)service3, serviceProperties3);
                detecter = this.createServiceDetecter(TestService1.SERVICE_NAME);
                detecter.acquire();
                String filter = String.valueOf('(') + vendor + '=' + ibmVendor + ')';
                List services = detecter.getServices(filter);
                int expected = 2;
                int actual = services.size();
                Assert.assertEquals((int)expected, (int)actual);
                filter = String.valueOf('(') + vendor + '=' + otiVendor + ')';
                services = detecter.getServices(filter);
                expected = 1;
                actual = services.size();
                Assert.assertEquals((int)expected, (int)actual);
                filter = String.valueOf('(') + vendor + '=' + xyzVendor + ')';
                services = detecter.getServices(filter);
                expected = 0;
                actual = services.size();
                Assert.assertEquals((int)expected, (int)actual);
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                if (registration3 != null) {
                    registration3.unregister();
                }
                if (registration2 != null) {
                    registration2.unregister();
                }
                if (registration1 != null) {
                    registration1.unregister();
                }
                if (detecter == null) throw throwable;
                detecter.release();
                throw throwable;
            }
            {
                Object var20_22 = null;
                if (registration3 == null) break block8;
            }
            registration3.unregister();
        }
        if (registration2 != null) {
            registration2.unregister();
        }
        if (registration1 != null) {
            registration1.unregister();
        }
        if (detecter == null) return;
        detecter.release();
    }

    public void test_isAcquired() {
        IServiceDetecter detecter = this.createServiceDetecter(TestService1.SERVICE_NAME);
        BundleContext context = this.getBundleContext();
        TestServiceImplementation service = new TestServiceImplementation();
        ServiceRegistration registration = context.registerService(TestService1.SERVICE_NAME, (Object)service, null);
        boolean acquired = detecter.isAcquired();
        Assert.assertFalse((boolean)acquired);
        List services = detecter.getServices();
        int expectedSize = 0;
        int actualSize = services.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        detecter.acquire();
        acquired = detecter.isAcquired();
        Assert.assertTrue((boolean)acquired);
        services = detecter.getServices();
        expectedSize = 1;
        actualSize = services.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        boolean exists = services.contains(service);
        Assert.assertTrue((boolean)exists);
        registration.unregister();
        detecter.release();
    }

    public void test_release() {
        IServiceDetecter detecter = this.createServiceDetecter(TestService1.SERVICE_NAME);
        final ValueHolder removedHolder = ValueHolder.nullValue();
        ServiceDetecterListener listener = new ServiceDetecterListener(){

            public void serviceAdded(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
            }

            public void serviceRemoved(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
                removedHolder.setValue(service);
            }
        };
        detecter.addServiceDetecterListener(listener);
        detecter.acquire();
        BundleContext context = this.getBundleContext();
        TestServiceImplementation service = new TestServiceImplementation();
        ServiceRegistration registration = context.registerService(TestService1.SERVICE_NAME, (Object)service, null);
        TestServiceImplementation expected = null;
        Object actual = removedHolder.getValue();
        Assert.assertSame(expected, (Object)actual);
        detecter.release();
        expected = service;
        actual = removedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        detecter.removeServiceDetecterListener(listener);
        registration.unregister();
    }

    public void test_setFilter() throws InvalidSyntaxException {
        TestServiceImplementation service1 = new TestServiceImplementation();
        Hashtable<String, String> properties1 = new Hashtable<String, String>(11);
        ((Dictionary)properties1).put("author", "John");
        ((Dictionary)properties1).put("company", "IBM");
        ((Dictionary)properties1).put("type", "automatic");
        TestServiceImplementation service2 = new TestServiceImplementation();
        Hashtable<String, String> properties2 = new Hashtable<String, String>(11);
        ((Dictionary)properties2).put("author", "Fred");
        ((Dictionary)properties2).put("company", "IBM");
        ((Dictionary)properties2).put("type", "manual");
        TestServiceImplementation service3 = new TestServiceImplementation();
        Hashtable<String, String> properties3 = new Hashtable<String, String>(11);
        ((Dictionary)properties3).put("author", "John");
        ((Dictionary)properties3).put("company", "Eclipse");
        ((Dictionary)properties3).put("type", "automatic");
        IServiceDetecter detecter = this.createServiceDetecter(TestService1.SERVICE_NAME);
        detecter.acquire();
        BundleContext context = this.getBundleContext();
        ServiceRegistration registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, properties1);
        ServiceRegistration registration2 = context.registerService(TestService1.SERVICE_NAME, (Object)service2, properties2);
        ServiceRegistration registration3 = context.registerService(TestService1.SERVICE_NAME, (Object)service3, properties3);
        String filter = "(author=John)";
        detecter.setFilter(filter);
        List services = detecter.getServices();
        int expectedSize = 2;
        int actualSize = services.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        boolean exists = services.contains(service1);
        Assert.assertTrue((boolean)exists);
        exists = services.contains(service3);
        Assert.assertTrue((boolean)exists);
        filter = "(author=Fred)";
        detecter.setFilter(filter);
        services = detecter.getServices();
        expectedSize = 1;
        actualSize = services.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        exists = services.contains(service2);
        Assert.assertTrue((boolean)exists);
        filter = "(company=IBM)";
        detecter.setFilter(filter);
        services = detecter.getServices();
        expectedSize = 2;
        actualSize = services.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        exists = services.contains(service1);
        Assert.assertTrue((boolean)exists);
        exists = services.contains(service2);
        Assert.assertTrue((boolean)exists);
        filter = "(&(company=IBM)(type=automatic))";
        detecter.setFilter(filter);
        services = detecter.getServices();
        expectedSize = 1;
        actualSize = services.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        exists = services.contains(service1);
        Assert.assertTrue((boolean)exists);
        filter = "(&(company=Eclipse)(type=manual))";
        detecter.setFilter(filter);
        services = detecter.getServices();
        expectedSize = 0;
        actualSize = services.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        registration3.unregister();
        registration2.unregister();
        registration1.unregister();
        detecter.release();
    }

    private static interface TestService1 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.ServiceDetecterTestCase$TestService1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static interface TestService2 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.ServiceDetecterTestCase$TestService2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static class TestServiceImplementation
    implements TestService1,
    TestService2 {
        private TestServiceImplementation() {
        }
    }
}

