/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.junit.internal.bundle.Activator;
import org.eclipse.soda.sat.core.util.CollectionUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class OutputStreamLogTestCase
extends AbstractSatTestCase {
    private static final int[] LOG_LEVELS = new int[]{1, 2, 3, 4};
    private static final String[] LOG_LEVEL_LABELS = new String[]{"[ERROR]", "[WARNING]", "[INFO]", "[DEBUG]"};
    private static final String[] MESSAGES = new String[]{"one", "two", "three", "four", "five"};
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.OutputStreamLogTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public OutputStreamLogTestCase(String name) {
        super(name);
    }

    private List[] createLoggedMessageLists(int size) {
        return new ArrayList[]{new ArrayList(size), new ArrayList(size), new ArrayList(size), new ArrayList(size)};
    }

    private LogService createLogService(List[] loggedMessageLists) {
        OutputStream[] outputStreams = this.createOutputStreams(loggedMessageLists);
        LogService log = this.createLogService(outputStreams);
        return log;
    }

    private LogService createLogService(OutputStream[] outputStreams) {
        LogService log = AbstractSatTestCase.FACTORY.createOutputStreamLog(outputStreams[0], outputStreams[1], outputStreams[2], outputStreams[3]);
        return log;
    }

    private LogService createNullLogService() {
        return AbstractSatTestCase.FACTORY.createOutputStreamLog(null, null, null, null);
    }

    private OutputStream createOutputStream(final List messages) {
        return new ByteArrayOutputStream(100){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(byte[] bytes) throws IOException {
                String message = new String(bytes);
                List list = messages;
                synchronized (list) {
                    messages.add(message);
                }
                super.write(bytes);
            }
        };
    }

    private OutputStream[] createOutputStreams(List[] loggedMessageLists) {
        return new OutputStream[]{this.createOutputStream(loggedMessageLists[0]), this.createOutputStream(loggedMessageLists[1]), this.createOutputStream(loggedMessageLists[2]), this.createOutputStream(loggedMessageLists[3])};
    }

    private ServiceReference createServiceReference() {
        return new ServiceReference(){

            public int compareTo(Object reference) {
                return 0;
            }

            public Bundle getBundle() {
                return OutputStreamLogTestCase.this.getBundle();
            }

            public Object getProperty(String key) {
                return null;
            }

            public String[] getPropertyKeys() {
                return null;
            }

            public Bundle[] getUsingBundles() {
                return null;
            }

            public boolean isAssignableTo(Bundle bundle, String className) {
                return false;
            }
        };
    }

    private Bundle getBundle() {
        return Activator.BUNDLE_CONTEXT != null ? Activator.BUNDLE_CONTEXT.getBundle() : null;
    }

    private String getMessage(int index) {
        int i = index % MESSAGES.length;
        String message = MESSAGES[i];
        return message;
    }

    public void test_asynchronous_logging() throws InterruptedException {
        AsynchronousLoggingTest test = new AsynchronousLoggingTest();
        test.run();
    }

    public void test_log() {
        int level;
        List[] loggedMessageLists = this.createLoggedMessageLists(5);
        LogService log = this.createLogService(loggedMessageLists);
        int i = 0;
        while (i < LOG_LEVELS.length) {
            level = LOG_LEVELS[i];
            int j = 0;
            while (j < MESSAGES.length) {
                String message = String.valueOf(this.getMessage(j)) + level;
                log.log(level, message);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < LOG_LEVELS.length) {
            level = LOG_LEVELS[i];
            String levelLabel = LOG_LEVEL_LABELS[i];
            List list = loggedMessageLists[i];
            int j = 0;
            while (j < MESSAGES.length) {
                String expected = String.valueOf(levelLabel) + ' ' + this.getMessage(j) + level + "\r\n";
                String actual = (String)list.get(j);
                Assert.assertEquals((String)expected, (String)actual);
                ++j;
            }
            ++i;
        }
        ServiceReference reference = this.createServiceReference();
        log.log(reference, 4, "hello");
    }

    public void test_null_log() {
        LogService log = this.createNullLogService();
        int i = 0;
        while (i < LOG_LEVELS.length) {
            int level = LOG_LEVELS[i];
            log.log(level, null);
            ++i;
        }
        Assert.assertTrue((boolean)true);
    }

    private class AsynchronousLoggingTest {
        private AsynchronousLoggingTest() {
        }

        private void assertSuccess(List[] loggedMessageLists, int threadCount, int iterations) {
            int expectedSize = threadCount * iterations;
            int i = 0;
            while (i < loggedMessageLists.length) {
                List loggedMessageList = loggedMessageLists[i];
                int j = 0;
                while (j < MESSAGES.length) {
                    List values = this.selectMessages(j, loggedMessageList);
                    int actualSize = values.size();
                    Assert.assertEquals((int)expectedSize, (int)actualSize);
                    ++j;
                }
                ++i;
            }
        }

        private CollectionUtility.Accessor createAccessor(String value) {
            return new CollectionUtility.Accessor(this, value){
                final /* synthetic */ AsynchronousLoggingTest this$1;
                private final /* synthetic */ String val$value;
                {
                    this.this$1 = asynchronousLoggingTest;
                    this.val$value = string;
                }

                public Object get(Object item) {
                    String message = (String)item;
                    boolean match = message.indexOf(this.val$value) != -1;
                    return match ? item : null;
                }
            };
        }

        private Runnable createRunnable(LogService log, int count) {
            return new Runnable(this, log, count){
                final /* synthetic */ AsynchronousLoggingTest this$1;
                private final /* synthetic */ LogService val$log;
                private final /* synthetic */ int val$count;
                {
                    this.this$1 = asynchronousLoggingTest;
                    this.val$log = logService;
                    this.val$count = n;
                }

                public void run() {
                    AsynchronousLoggingTest.access$0(this.this$1, this.val$log, this.val$count);
                }
            };
        }

        private Thread createThread(int id, LogService log, int count) {
            Runnable runnable = this.createRunnable(log, count);
            Thread thread = new Thread(runnable, "Logger-" + id);
            return thread;
        }

        private void process(LogService log, int count) {
            int i = 0;
            while (i < count) {
                int j = 0;
                while (j < MESSAGES.length) {
                    String message = OutputStreamLogTestCase.this.getMessage(j);
                    log.log(1, message);
                    log.log(2, message);
                    log.log(3, message);
                    log.log(4, message);
                    Thread.yield();
                    ++j;
                }
                ++i;
            }
        }

        public void run() throws InterruptedException {
            int threadCount = 15;
            int iterations = 75;
            int size = MESSAGES.length * threadCount * iterations;
            List[] loggedMessageLists = OutputStreamLogTestCase.this.createLoggedMessageLists(size);
            LogService log = OutputStreamLogTestCase.this.createLogService(loggedMessageLists);
            ArrayList threads = new ArrayList(threadCount);
            this.startThreads(log, threadCount, iterations, threads);
            this.waitForThreadsToTerminate(threads);
            this.assertSuccess(loggedMessageLists, threadCount, iterations);
        }

        private List selectMessages(int index, List loggedMessageList) {
            String message = OutputStreamLogTestCase.this.getMessage(index);
            CollectionUtility.Accessor accessor = this.createAccessor(message);
            CollectionUtility utility = CollectionUtility.getInstance();
            List values = utility.select((Collection)loggedMessageList, accessor);
            return values;
        }

        private void startThreads(LogService log, int threadCount, int iterations, List threads) {
            int i = 0;
            while (i < threadCount) {
                Thread thread = this.createThread(i + 1, log, iterations);
                threads.add(thread);
                thread.start();
                ++i;
            }
        }

        private void waitForThreadsToTerminate(List threads) throws InterruptedException {
            int i = 0;
            while (i < threads.size()) {
                Thread thread = (Thread)threads.get(i);
                thread.join();
                ++i;
            }
        }

        static /* synthetic */ void access$0(AsynchronousLoggingTest asynchronousLoggingTest, LogService logService, int n) {
            asynchronousLoggingTest.process(logService, n);
        }
    }
}

