/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.interfaces.IQueue;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.junit.util.ValueHolder;

public class QueueTestCase
extends AbstractSatTestCase {
    private static final String RED = "red";
    private static final String BLUE = "blue";
    private static final String GREEN = "green";
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.QueueTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public QueueTestCase(String name) {
        super(name);
    }

    private IQueue createQueue() {
        return this.createQueue(10);
    }

    private IQueue createQueue(int capacity) {
        return AbstractSatTestCase.FACTORY.createQueue(capacity);
    }

    public void test_add() {
        IQueue queue = this.createQueue(2);
        int expectedSize = 0;
        int actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        queue.add((Object)RED);
        expectedSize = 1;
        actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        queue.add((Object)BLUE);
        expectedSize = 2;
        actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        queue.add((Object)GREEN);
        expectedSize = 3;
        actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    public void test_contains() throws InterruptedException {
        IQueue queue = this.createQueue();
        boolean state = queue.isEmpty();
        Assert.assertTrue((boolean)state);
        state = queue.contains((Object)RED);
        Assert.assertFalse((boolean)state);
        queue.add((Object)RED);
        state = queue.contains((Object)RED);
        Assert.assertTrue((boolean)state);
        state = queue.contains((Object)BLUE);
        Assert.assertFalse((boolean)state);
        queue.add((Object)BLUE);
        state = queue.contains((Object)BLUE);
        Assert.assertTrue((boolean)state);
        Object item = queue.remove();
        state = queue.contains(item);
        Assert.assertFalse((boolean)state);
        item = queue.remove();
        state = queue.contains(item);
        Assert.assertFalse((boolean)state);
        try {
            queue.contains(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }

    public void test_isEmpty() throws InterruptedException {
        IQueue queue = this.createQueue();
        boolean state = queue.isEmpty();
        Assert.assertTrue((boolean)state);
        queue.add((Object)RED);
        state = queue.isEmpty();
        Assert.assertFalse((boolean)state);
        queue.remove();
        state = queue.isEmpty();
        Assert.assertTrue((boolean)state);
    }

    public void test_producers_and_consumers() throws InterruptedException {
        ProducerConsumerTest test = new ProducerConsumerTest();
        test.run();
    }

    public void test_remove() throws InterruptedException {
        final IQueue queue = this.createQueue();
        queue.add((Object)RED);
        queue.add((Object)GREEN);
        queue.add((Object)BLUE);
        Object item = queue.remove();
        Assert.assertEquals((Object)item, (Object)RED);
        item = queue.remove();
        Assert.assertEquals((Object)item, (Object)GREEN);
        item = queue.remove();
        Assert.assertEquals((Object)item, (Object)BLUE);
        boolean empty = queue.isEmpty();
        Assert.assertTrue((boolean)empty);
        item = queue.remove(1L);
        Assert.assertNull((Object)item);
        final ValueHolder holder = ValueHolder.nullValue();
        Assert.assertNull((Object)holder.getValue());
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    queue.remove();
                    holder.setFalse();
                }
                catch (InterruptedException interruptedException) {
                    holder.setTrue();
                }
            }
        };
        Thread thread = new Thread(runnable, "QueueTestCase.test_remove");
        thread.start();
        thread.interrupt();
        thread.join();
        Assert.assertTrue((boolean)holder.isTrue());
    }

    public void test_size() throws InterruptedException {
        IQueue queue = this.createQueue(2);
        int expectedSize = 0;
        int actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        queue.add((Object)RED);
        expectedSize = 1;
        actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        queue.add((Object)BLUE);
        expectedSize = 2;
        actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        queue.add((Object)GREEN);
        expectedSize = 3;
        actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        queue.remove();
        expectedSize = 2;
        actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        queue.remove();
        expectedSize = 1;
        actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        queue.remove();
        expectedSize = 0;
        actualSize = queue.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    private class ProducerConsumerTest {
        private ProducerConsumerTest() {
        }

        private void assertSuccess(ValueHolder counter, List items) {
            int expectedSize = counter.getIntValue();
            int actualSize = items.size();
            Assert.assertEquals((int)expectedSize, (int)actualSize);
        }

        private Runnable createConsumerRunnable(ValueHolder runHolder, IQueue queue, List items) {
            return new Runnable(this, runHolder, queue, items){
                final /* synthetic */ ProducerConsumerTest this$1;
                private final /* synthetic */ ValueHolder val$runHolder;
                private final /* synthetic */ IQueue val$queue;
                private final /* synthetic */ List val$items;
                {
                    this.this$1 = producerConsumerTest;
                    this.val$runHolder = valueHolder;
                    this.val$queue = iQueue;
                    this.val$items = list;
                }

                public void run() {
                    try {
                        while (ProducerConsumerTest.access$0(this.this$1, this.val$runHolder, this.val$queue)) {
                            ProducerConsumerTest.access$1(this.this$1, this.val$queue, this.val$items);
                            Thread.yield();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            };
        }

        private void createConsumerThread(int id, ValueHolder runHolder, List items, IQueue queue, List threads) {
            Runnable runnable = this.createConsumerRunnable(runHolder, queue, items);
            Thread thread = new Thread(runnable, "Consumer-" + id);
            threads.add(thread);
        }

        private void createConsumerThreads(int count, ValueHolder keepRunning, List items, IQueue queue, List threads) {
            int i = 0;
            while (i < count) {
                this.createConsumerThread(i + 1, keepRunning, items, queue, threads);
                ++i;
            }
        }

        private Runnable createProducerRunnable(ValueHolder runHolder, IQueue queue, ValueHolder idHolder) {
            return new Runnable(this, runHolder, queue, idHolder){
                final /* synthetic */ ProducerConsumerTest this$1;
                private final /* synthetic */ ValueHolder val$runHolder;
                private final /* synthetic */ IQueue val$queue;
                private final /* synthetic */ ValueHolder val$idHolder;
                {
                    this.this$1 = producerConsumerTest;
                    this.val$runHolder = valueHolder;
                    this.val$queue = iQueue;
                    this.val$idHolder = valueHolder2;
                }

                public void run() {
                    while (ProducerConsumerTest.access$2(this.this$1, this.val$runHolder)) {
                        ProducerConsumerTest.access$3(this.this$1, this.val$queue, this.val$idHolder);
                        Thread.yield();
                    }
                }
            };
        }

        private void createProducerThread(int id, ValueHolder keepRunning, ValueHolder counterHolder, IQueue queue, List threads) {
            Runnable runnable = this.createProducerRunnable(keepRunning, queue, counterHolder);
            Thread thread = new Thread(runnable, "Producer-" + id);
            threads.add(thread);
        }

        private void createProducerThreads(int count, ValueHolder keepRunning, ValueHolder counter, IQueue queue, List threads) {
            int i = 0;
            while (i < count) {
                this.createProducerThread(i + 1, keepRunning, counter, queue, threads);
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getNextId(ValueHolder idHolder) {
            ValueHolder valueHolder = idHolder;
            synchronized (valueHolder) {
                int value = idHolder.getIntValue();
                idHolder.setValue(++value);
                return value;
            }
        }

        private boolean keepConsuming(ValueHolder runHolder, IQueue queue) {
            return !queue.isEmpty() || runHolder.isTrue();
        }

        private boolean keepProducing(ValueHolder runHolder) {
            return runHolder.isTrue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processConsumer(IQueue queue, List items) throws InterruptedException {
            Object item = queue.remove();
            List list = items;
            synchronized (list) {
                items.add(item);
            }
        }

        private void processProducer(IQueue queue, ValueHolder idHolder) {
            int value = this.getNextId(idHolder);
            Integer item = new Integer(value);
            queue.add((Object)item);
        }

        public void run() throws InterruptedException {
            ArrayList items = new ArrayList(25000);
            IQueue queue = QueueTestCase.this.createQueue();
            ValueHolder keepRunning = ValueHolder.trueValue();
            ValueHolder counter = ValueHolder.zeroValue();
            int producerCount = 3;
            int consumerCount = 3;
            int threadCount = producerCount + consumerCount;
            ArrayList threads = new ArrayList(threadCount);
            this.createProducerThreads(producerCount, keepRunning, counter, queue, threads);
            this.createConsumerThreads(producerCount, keepRunning, items, queue, threads);
            this.startThreads(threads);
            QueueTestCase.this.delay(100L);
            this.stopThreads(threads, keepRunning);
            this.assertSuccess(counter, items);
        }

        private void startThreads(List threads) {
            Iterator iterator = threads.iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                thread.start();
            }
        }

        private void stopThreads(List threads, ValueHolder keepRunning) throws InterruptedException {
            keepRunning.setFalse();
            Iterator iterator = threads.iterator();
            InterruptedException caughtException = null;
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException exception) {
                    caughtException = exception;
                }
            }
            if (caughtException != null) {
                throw caughtException;
            }
        }

        static /* synthetic */ boolean access$0(ProducerConsumerTest producerConsumerTest, ValueHolder valueHolder, IQueue iQueue) {
            return producerConsumerTest.keepConsuming(valueHolder, iQueue);
        }

        static /* synthetic */ void access$1(ProducerConsumerTest producerConsumerTest, IQueue iQueue, List list) throws InterruptedException {
            producerConsumerTest.processConsumer(iQueue, list);
        }

        static /* synthetic */ boolean access$2(ProducerConsumerTest producerConsumerTest, ValueHolder valueHolder) {
            return producerConsumerTest.keepProducing(valueHolder);
        }

        static /* synthetic */ void access$3(ProducerConsumerTest producerConsumerTest, IQueue iQueue, ValueHolder valueHolder) {
            producerConsumerTest.processProducer(iQueue, valueHolder);
        }
    }
}

