/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.util.List;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitFormPage;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class DependPage
extends DeviceKitFormPage {
    public DependPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void createDependSection(IManagedForm managedForm, Composite parent, TagElement element) {
        SortedSet commandList = new SortedSet();
        SortedSet measurementList = new SortedSet();
        SortedSet signalList = new SortedSet();
        List commands = element.getAllChildrenWithTagCodes(new int[]{79}, new int[]{86, 86, 8});
        commandList.addAll(commands);
        List measurements = element.getAllChildrenWithTagCodes(new int[]{80}, new int[]{86, 86, 8});
        measurementList.addAll(measurements);
        List signals = element.getAllChildrenWithTagCodes(new int[]{81}, new int[]{86, 86, 8});
        signalList.addAll(signals);
        String name = element.getAnyIdentifier();
        String betterName = CodeUtilities.betterName((String)name, (int)2);
        final Section elementSection = this.createTreeSection(this.getToolkit(), parent, betterName, 3);
        elementSection.addExpansionListener(new IExpansionListener((List)commandList, managedForm, (List)measurementList, (List)signalList){
            private final /* synthetic */ List val$commandList;
            private final /* synthetic */ IManagedForm val$managedForm;
            private final /* synthetic */ List val$measurementList;
            private final /* synthetic */ List val$signalList;
            {
                this.val$commandList = list;
                this.val$managedForm = iManagedForm;
                this.val$measurementList = list2;
                this.val$signalList = list3;
            }

            public void expansionStateChanged(ExpansionEvent e) {
                Object source = e.getSource();
                if (source instanceof Section) {
                    Section section = (Section)e.getSource();
                    Composite elementContainer = (Composite)elementSection.getClient();
                    if (elementContainer != null && !elementContainer.isDisposed() && elementContainer.getChildren().length == 0 && section.isExpanded()) {
                        Composite cparent = (Composite)elementSection.getClient();
                        Section commandsSection = DependPage.this.createTagsSection(cparent, this.val$commandList, "command");
                        SectionPart commandsPart = new SectionPart(commandsSection);
                        this.val$managedForm.addPart((IFormPart)commandsPart);
                        Section measurementsSection = DependPage.this.createTagsSection(cparent, this.val$measurementList, "measurement");
                        SectionPart measurementsPart = new SectionPart(measurementsSection);
                        this.val$managedForm.addPart((IFormPart)measurementsPart);
                        Section signalsSection = DependPage.this.createTagsSection(cparent, this.val$signalList, "signal");
                        SectionPart signalsPart = new SectionPart(signalsSection);
                        this.val$managedForm.addPart((IFormPart)signalsPart);
                        ScrolledForm scrolledPageContent = DependPage.this.getScrolledForm((Control)section);
                        section.removeExpansionListener((IExpansionListener)this);
                        if (scrolledPageContent != null) {
                            scrolledPageContent.reflow(true);
                        }
                    }
                }
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite parent = this.setup(managedForm, 1);
        DeviceKitTagModel dkFileModel = this.getTagModel();
        if (dkFileModel != null) {
            try {
                MainTagElement mainElement = dkFileModel.getMainElement();
                if (mainElement != null) {
                    List profileParent = mainElement.getAllChildrenWithTagCodes(new int[]{83});
                    int i = 0;
                    while (i < profileParent.size()) {
                        TagElement profileUse = (TagElement)profileParent.get(i);
                        List profiles = profileUse.getAllChildrenWithTagCodes(new int[]{86});
                        int j = 0;
                        while (j < profiles.size()) {
                            TagElement profile = (TagElement)profiles.get(j);
                            this.createDependSection(managedForm, parent, profile);
                            ++j;
                        }
                        ++i;
                    }
                    List profileUses = mainElement.getAllChildrenWithTagCodes(new int[]{85});
                    int i2 = 0;
                    while (i2 < profileUses.size()) {
                        TagElement profileUse = (TagElement)profileUses.get(i2);
                        List profiles = profileUse.getAllChildrenWithTagCodes(new int[]{86});
                        int j = 0;
                        while (j < profiles.size()) {
                            TagElement profile = (TagElement)profiles.get(j);
                            this.createDependSection(managedForm, parent, profile);
                            ++j;
                        }
                        ++i2;
                    }
                    List adapters = mainElement.getAllChildrenWithTagCodes(new int[]{72, 1072});
                    int i3 = 0;
                    while (i3 < adapters.size()) {
                        TagElement adapter = (TagElement)adapters.get(i3);
                        String idref = adapter.getIdRef();
                        if (idref != null && idref.length() > 0) {
                            this.createDependSection(managedForm, parent, adapter);
                        }
                        ++i3;
                    }
                    List devices = mainElement.getAllChildrenWithTagCodes(new int[]{8});
                    int i4 = 0;
                    while (i4 < devices.size()) {
                        TagElement device = (TagElement)devices.get(i4);
                        String idref = device.getIdRef();
                        if (idref != null && idref.length() > 0) {
                            this.createDependSection(managedForm, parent, device);
                        }
                        ++i4;
                    }
                    List transports = mainElement.getAllChildrenWithTagCodes(new int[]{9});
                    int i5 = 0;
                    while (i5 < transports.size()) {
                        TagElement transport = (TagElement)transports.get(i5);
                        String idref = transport.getIdRef();
                        if (idref != null && idref.length() > 0) {
                            this.createDependSection(managedForm, parent, transport);
                        }
                        ++i5;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

