/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.model.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.internal.model.java.Field;
import org.eclipse.soda.devicekit.generator.internal.model.java.JavaElement;
import org.eclipse.soda.devicekit.generator.internal.model.java.Method;
import org.eclipse.soda.devicekit.generator.internal.model.java.SourceField;
import org.eclipse.soda.devicekit.generator.internal.model.java.SourceMethod;
import org.eclipse.soda.devicekit.generator.internal.print.java.TypePrinter;
import org.eclipse.soda.devicekit.generator.model.java.IField;
import org.eclipse.soda.devicekit.generator.model.java.IMethod;
import org.eclipse.soda.devicekit.generator.model.java.IType;

public class Type
extends JavaElement
implements IType {
    private String pack;
    private long fSortOrder;
    private List fFields;
    private List fMethods;
    private boolean fNLS = false;
    private String fSuperClass;
    private String[] fSuperInterfaces;
    private Map fTypes;

    public Type(String pack, String name) {
        this(pack, name, 1);
    }

    public Type(String pack, String name, int fileType) {
        this(pack, name, fileType, 1L, false);
    }

    public Type(String pack, String name, int fileType, long identifiers, boolean NLS) {
        super(name);
        this.pack = pack == null ? "" : pack;
        this.fFields = new ArrayList();
        this.fMethods = new ArrayList();
        this.fTypes = new HashMap();
        this.setFileType(fileType);
        this.setNLS(NLS);
        this.setIdentifiers(identifiers);
        this.setSuperClass("Object");
    }

    public void addExtraField(String key, String source) {
        SourceField field = new SourceField(key, source);
        this.fFields.add(field);
    }

    public void addExtraMethod(String key, String source) {
        SourceMethod method = new SourceMethod(key, source);
        this.fMethods.add(method);
    }

    public void addSuperInterface(String superInterface) {
        if (this.fSuperInterfaces == null) {
            this.fSuperInterfaces = new String[]{superInterface};
        } else {
            String[] fTemp = new String[this.fSuperInterfaces.length + 1];
            System.arraycopy(this.fSuperInterfaces, 0, fTemp, 0, this.fSuperInterfaces.length);
            fTemp[this.fSuperInterfaces.length] = superInterface;
            this.fSuperInterfaces = fTemp;
        }
    }

    public IField createField(String type, String name) {
        Field field = new Field(type, name);
        field.setFileType(this.getFileType());
        this.fFields.add(field);
        return field;
    }

    public IField createField(String[] javaDoc, long identifiers, String type, String name, String value) {
        Field field = new Field(type, name);
        field.setIdentifiers(identifiers);
        field.setValue(value);
        field.setComment(javaDoc);
        field.setFileType(this.getFileType());
        this.fFields.add(field);
        return field;
    }

    public IType createInnerType(String name) {
        if (this.isClass()) {
            Type type = new Type(this.pack, name, 1);
            this.fTypes.put(name, type);
            return type;
        }
        if (this.isInterface()) {
            Type type = new Type(this.pack, name, 0);
            this.fTypes.put(name, type);
            return type;
        }
        System.out.println("Cannot add inner type to interface");
        return null;
    }

    public IMethod createMethod(String name) {
        Method meth = new Method(name);
        meth.setConstructor(name.equals(this.getName()));
        this.fMethods.add(meth);
        return meth;
    }

    public IMethod[] getConstructors() {
        ArrayList<IMethod> v = new ArrayList<IMethod>();
        IMethod[] allMethods = this.getMethods();
        int i = 0;
        while (i < allMethods.length) {
            if (allMethods[i].isConstructor()) {
                v.add(allMethods[i]);
            }
            ++i;
        }
        IMethod[] cons = new IMethod[v.size()];
        cons = v.toArray(cons);
        return cons;
    }

    public IField getField(String name) {
        int i = 0;
        while (i < this.fFields.size()) {
            IField field = (IField)this.fFields.get(i);
            if (field.getName().equals(name)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public IField[] getFields() {
        IField[] fields = new IField[this.fFields.size()];
        int count = 0;
        Iterator values = this.fFields.iterator();
        while (values.hasNext()) {
            fields[count++] = (IField)values.next();
        }
        return fields;
    }

    public IMethod[] getMethods() {
        IMethod[] methods = new IMethod[this.fMethods.size()];
        int count = 0;
        Iterator values = this.fMethods.iterator();
        while (values.hasNext()) {
            methods[count++] = (IMethod)values.next();
        }
        return methods;
    }

    public boolean getNLS() {
        return this.fNLS;
    }

    public IMethod[] getNonConstructorMethods() {
        ArrayList<IMethod> v = new ArrayList<IMethod>();
        IMethod[] allMethods = this.getMethods();
        int i = 0;
        while (i < allMethods.length) {
            if (!allMethods[i].isConstructor()) {
                v.add(allMethods[i]);
            }
            ++i;
        }
        IMethod[] cons = new IMethod[v.size()];
        cons = v.toArray(cons);
        return cons;
    }

    public String getPackage() {
        return this.pack;
    }

    public long getSortOrder() {
        return this.fSortOrder;
    }

    public String[] getSuperInterfaces() {
        return this.fSuperInterfaces;
    }

    public String getSuperclass() {
        return this.fSuperClass;
    }

    public IType getType(String name) {
        return (IType)this.fTypes.get(name);
    }

    public IType[] getTypes() {
        IType[] types = new IType[this.fTypes.size()];
        int count = 0;
        Iterator values = this.fTypes.values().iterator();
        while (values.hasNext()) {
            types[count++] = (IType)values.next();
        }
        return types;
    }

    public String print(int indentation) {
        return new TypePrinter(this, indentation).getContents();
    }

    public void setNLS(boolean NLS) {
        this.fNLS = NLS;
    }

    public void setSortOrder(long sortOrder) {
        this.fSortOrder = sortOrder;
    }

    public void setSuperClass(String superClass) {
        this.fSuperClass = superClass;
    }

    public void setSuperInterfaces(String[] interfaces) {
        this.fSuperInterfaces = interfaces;
    }
}

