/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.samples.extension.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.soda.devicekit.ui.samples.extension.WizardContent;
import org.eclipse.soda.devicekit.ui.samples.extension.project.EclipseProjectConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EclipseProject
implements EclipseProjectConstants,
Comparable {
    private File zipFile;
    private String projectName;
    private WizardContent wizardContent;
    private boolean install = false;
    private String pluginjardir;

    public EclipseProject(File file, WizardContent wizardContent) {
        this.setWizardContent(wizardContent);
        try {
            this.zipFile = file;
            this.projectName = this.extractProjectName(new ZipFile(this.zipFile));
        }
        catch (Exception e) {
            System.out.println("file " + file);
            e.printStackTrace();
        }
    }

    public EclipseProject(String pluginjardir, String projectName, WizardContent wizardContent) {
        this.pluginjardir = pluginjardir;
        this.projectName = projectName;
        this.setWizardContent(wizardContent);
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    private String extractProjectName(ZipFile zipFile) throws IOException, SAXException {
        String string;
        ZipFile tzipFile;
        block4: {
            tzipFile = zipFile;
            InputStream stream = null;
            try {
                ZipEntry entry = tzipFile.getEntry(".project");
                stream = tzipFile.getInputStream(entry);
                string = this.extractProjectName(stream);
                Object var5_6 = null;
                if (stream == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var5_7 = null;
                    if (stream != null) {
                        stream.close();
                        stream = null;
                    }
                    if (tzipFile == null) break block5;
                    tzipFile.close();
                    tzipFile = null;
                }
                throw throwable;
            }
            stream.close();
            stream = null;
        }
        if (tzipFile != null) {
            tzipFile.close();
            tzipFile = null;
        }
        return string;
    }

    private String extractProjectName(InputStream stream) throws IOException, SAXException {
        try {
            Document document;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document node = document = parser.parse(new InputSource(stream));
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                String name = this.extractProjectName(list.item(i));
                if (name.length() > 0) {
                    return name;
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        return new String();
    }

    private String extractProjectName(Node node) {
        String nodeName = node.getNodeName();
        if ("projectDescription".equals(nodeName)) {
            NodeList list = node.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                String name = this.extractProjectName(list.item(i));
                if (name.length() > 0) {
                    return name;
                }
                ++i;
            }
        } else if ("name".equals(node.getNodeName())) {
            String value = this.getNodeValue(node);
            return value;
        }
        return new String();
    }

    private String getNodeValue(Node node) {
        StringBuffer buffer = new StringBuffer(64);
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (3 == childNode.getNodeType()) {
                buffer.append(childNode.getNodeValue());
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getPluginjardir() {
        return this.pluginjardir;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public WizardContent getWizardContent() {
        return this.wizardContent;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public boolean isInstall() {
        return this.install;
    }

    public void setInstall(boolean install) {
        this.install = install;
    }

    public void setWizardContent(WizardContent wizardContent) {
        this.wizardContent = wizardContent;
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public String toString() {
        return this.projectName;
    }
}

