/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transform.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.data.IntegerFraction;
import org.eclipse.soda.dk.transform.IntegerScaleTransform;

public class IntegerScaleTransformTestcase
extends TestCase {
    private IntegerScaleTransform transform;
    private Object obj;
    static /* synthetic */ Class class$0;

    public IntegerScaleTransformTestcase(String name) {
        super(name);
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.transform.testcase.IntegerScaleTransformTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testConstructorWithZero() {
        RuntimeException ee = null;
        try {
            this.transform = new IntegerScaleTransform(0);
        }
        catch (RuntimeException e) {
            ee = e;
        }
        IntegerScaleTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        IntegerScaleTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof IllegalArgumentException));
    }

    public void testDecodeForException() {
        this.transform = new IntegerScaleTransform(1);
        this.obj = new Object();
        RuntimeException ee = null;
        try {
            this.transform.decode(this.obj);
        }
        catch (RuntimeException e) {
            ee = e;
        }
        IntegerScaleTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        IntegerScaleTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testDecodeForType() {
        this.transform = new IntegerScaleTransform(1);
        this.obj = this.transform.decode((Object)new Integer(1000));
        IntegerScaleTransformTestcase.assertTrue((String)"Should return type == Integer", (boolean)(this.obj instanceof Integer));
    }

    public void testDecodeScaleBy5() {
        this.transform = new IntegerScaleTransform(5);
        this.obj = this.transform.decode((Object)new Integer(5));
        IntegerScaleTransformTestcase.assertTrue((String)"Should Multiply and Equal 25", (this.obj instanceof Integer && (Integer)this.obj == 25 ? 1 : 0) != 0);
    }

    public void testEncodeForException() {
        this.transform = new IntegerScaleTransform(1);
        this.obj = new Object();
        RuntimeException ee = null;
        try {
            this.transform.encode(this.obj);
        }
        catch (RuntimeException e) {
            ee = e;
        }
        IntegerScaleTransformTestcase.assertTrue((String)"Should Have Thrown Exception", (ee != null ? 1 : 0) != 0);
        IntegerScaleTransformTestcase.assertTrue((String)("Unknown Exception Thrown " + ee), (boolean)(ee instanceof ClassCastException));
    }

    public void testEncodeForTypeInteger() {
        this.transform = new IntegerScaleTransform(1);
        this.obj = this.transform.encode((Object)new Integer(1000));
        IntegerScaleTransformTestcase.assertTrue((String)"Should return type == Integer", (boolean)(this.obj instanceof Integer));
    }

    public void testEncodeForTypeIntegerFraction() {
        this.transform = new IntegerScaleTransform(3);
        this.obj = this.transform.encode((Object)new Integer(1000));
        IntegerScaleTransformTestcase.assertTrue((String)"Should return type == Integer", (boolean)(this.obj instanceof IntegerFraction));
    }

    public void testEncodeScaleBy3WithMod() {
        this.transform = new IntegerScaleTransform(3);
        this.obj = this.transform.encode((Object)new Integer(10));
        IntegerScaleTransformTestcase.assertTrue((String)("Should Divide Unevenly and Equal 3" + (this.obj instanceof IntegerFraction) + (((IntegerFraction)this.obj).intValue() == 3)), (this.obj instanceof IntegerFraction && ((IntegerFraction)this.obj).intValue() == 3 ? 1 : 0) != 0);
    }

    public void testEncodeScaleBy5NoMod() {
        this.transform = new IntegerScaleTransform(5);
        this.obj = this.transform.encode((Object)new Integer(5));
        IntegerScaleTransformTestcase.assertTrue((String)"Should Divide Evenly and Equal 1", (this.obj instanceof Integer && (Integer)this.obj == 1 ? 1 : 0) != 0);
    }

    public void testTransformConstruction() {
        this.transform = new IntegerScaleTransform(1);
        IntegerScaleTransformTestcase.assertTrue((String)"IntegerScaleTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new IntegerScaleTransform(-1);
        IntegerScaleTransformTestcase.assertTrue((String)"IntegerScaleTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new IntegerScaleTransform(Integer.MAX_VALUE);
        IntegerScaleTransformTestcase.assertTrue((String)"IntegerScaleTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
        this.transform = new IntegerScaleTransform(Integer.MIN_VALUE);
        IntegerScaleTransformTestcase.assertTrue((String)"IntegerScaleTransform Constructor should not return a Null Object", (this.transform != null ? 1 : 0) != 0);
    }
}

