/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.block;

import java.util.List;
import org.eclipse.soda.dk.parameter.IntegerParameter;
import org.eclipse.soda.dk.parameter.service.BlockService;
import org.eclipse.soda.dk.parameter.service.CountBlockService;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class CountBlock
extends IntegerParameter
implements BlockService,
CountBlockService {
    public CountBlock() {
    }

    public CountBlock(int length) {
        super("", length);
    }

    public CountBlock(String key) {
        super(key);
    }

    public CountBlock(String key, int length) {
        super(key, length);
    }

    public CountBlock(String key, int offset, int length) {
        super(key, offset, length);
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        int length = this.getLength(cursor);
        int count = this.updateCount(CountBlock.getUnsignedInteger(container, this.getOffsetValue(cursor), length));
        Integer number = CountBlock.createInteger(count);
        if (cursor != null) {
            super.updateCursor(cursor, length);
            cursor.setCount(count);
        } else {
            super.updateCursor(cursor);
        }
        return number;
    }

    public byte[] encodeBytes(byte[] container, Object data, ParameterCursorService cursor) {
        CountBlockService countBlock = cursor.getCountBlock();
        int count = cursor.getCount();
        if (countBlock == null) {
            cursor.setCountBlock((CountBlockService)this);
            int bytesLength = cursor.getMessageLength();
            byte[] bytes = CountBlock.setBits(container, bytesLength, this.getOffsetAbsolute(cursor), this.getLength(cursor), 0L, this.isInsert(cursor));
            cursor.setOffsetAbsolute(this.getOffsetAbsolute(cursor) + this.getLength(cursor));
            if (count < 0) {
                if (data instanceof List) {
                    List list = (List)data;
                    count = list.size();
                }
                if (count >= 0) {
                    cursor.setCount(this.getCorrectCount(count));
                }
            }
            if (this.isInsert(cursor)) {
                cursor.updateMessageLength(this.getLength());
            }
            return bytes;
        }
        int offset = this.getOffsetAbsolute(cursor.getCountCursor());
        int length = this.getLength(cursor.getCountCursor());
        byte[] bytes = CountBlock.setBits(container, offset, length, this.getCorrectCount(count), false);
        cursor.setLengthBlock(null);
        return bytes;
    }

    public int getCorrectCount(int count) {
        return count;
    }

    public boolean isConstantParameter() {
        return true;
    }

    protected int updateCount(int length) {
        return length;
    }

    protected void updateCursor(ParameterCursorService cursor) {
    }
}

