/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MultiParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class MapParameter
extends MultiParameter
implements ParameterService {
    protected int offset = -1;

    public MapParameter() {
    }

    public MapParameter(ParameterService[] parameters) {
        super("map", parameters);
    }

    public MapParameter(String key) {
        super(key);
    }

    public MapParameter(String key, ParameterService[] parameters) {
        super(key, parameters);
    }

    public MapParameter(String key, ParameterService[] parameters, ParameterService countBlock) {
        super(key, parameters, countBlock);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        HashMap<Object, Object> result = new HashMap<Object, Object>(length << 1);
        int count = 0;
        int index = 0;
        while (index < length) {
            ParameterService parameter = parameters[index];
            Object value = parameter.decodeValue(message, cursor);
            if (!parameter.isConstantParameter() && value != null) {
                String key = parameter.getKey();
                if (key != null && key.length() > 0) {
                    result.put(key, value);
                } else {
                    result.put(EscObject.createInteger(count), value);
                }
                ++count;
            }
            ++index;
        }
        String key = this.getKey();
        if (key != null && key.length() > 0) {
            result.put("key", key);
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        MessageService resultMessage = message;
        if (value != null) {
            Map values = EscConfiguration.mapObject(value);
            if (values != null) {
                int index = 0;
                while (index < length) {
                    ParameterService parameter = parameters[index];
                    if (parameter.isConstantParameter()) {
                        try {
                            resultMessage = parameter.encodeValue(resultMessage, value, cursor);
                        }
                        catch (RuntimeException exception) {
                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("exception=" + exception + ",parameter=" + parameter + "\n,value=" + value + "\n,message=" + message + "\n,cursor=" + cursor);
                            throw illegalArgumentException;
                        }
                    } else {
                        String key = parameter.getKey();
                        Object parameterValue = values.get(key);
                        resultMessage = parameter.encodeValue(resultMessage, parameterValue, cursor);
                    }
                    ++index;
                }
            } else {
                StringBuffer buffer = new StringBuffer();
                buffer.append("key=");
                buffer.append(this.getKey());
                buffer.append(",value=");
                buffer.append(value);
                throw new IllegalArgumentException(buffer.toString());
            }
        }
        return resultMessage;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

