/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MultiParameter;
import org.eclipse.soda.dk.parameter.service.LengthBlockService;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class VariableLengthParameter
extends MultiParameter {
    public VariableLengthParameter() {
    }

    public VariableLengthParameter(ParameterService[] parameters) {
        super("", parameters);
    }

    public VariableLengthParameter(String key) {
        super(key);
    }

    public VariableLengthParameter(String key, ParameterService[] parameters) {
        super(key, parameters);
    }

    public VariableLengthParameter(String key, ParameterService[] parameters, ParameterService countBlock) {
        super(key, parameters, countBlock);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        Object result = null;
        int index = 0;
        while (index < length) {
            ParameterService parameter = parameters[index];
            Object value = parameter.decodeValue(message, cursor);
            if (!parameter.isConstantParameter()) {
                result = value;
            }
            ++index;
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        MessageService result = message;
        ParameterCursorService tcursor = this.createCursorChild(cursor);
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        int index = 0;
        while (index < length) {
            ParameterService parameter = parameters[index];
            if (parameter.isConstantParameter()) {
                tcursor.setInsert(true);
            }
            result = parameter.encodeValue(result, value, tcursor);
            ++index;
        }
        LengthBlockService lengthService = tcursor.getLengthBlock();
        if (lengthService != null) {
            int end = tcursor.getOffsetAbsolute();
            int start = cursor.getOffsetAbsolute();
            tcursor.setLength(end - start - lengthService.getLength());
            result = lengthService.encodeValue(message, value, tcursor);
            cursor.setOffsetAbsolute(this.getOffsetAbsolute(tcursor));
        }
        return result;
    }

    public String getKey() {
        String key = super.getKey();
        if (key != null && key.length() > 0) {
            return key;
        }
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        int index = 0;
        while (index < length) {
            ParameterService parameter = parameters[index];
            if (!parameter.isConstantParameter()) {
                return parameter.getKey();
            }
            ++index;
        }
        return key;
    }

    public boolean needsCursor() {
        return true;
    }
}

