/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.write.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.generic.adapter.service.GenericWriteListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericWriteListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericWriteService;
import org.eclipse.soda.dk.generic.write.profile.service.GenericWriteProfileService;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.write.profile.RfidWriteProfile;

public class GenericWriteProfile
extends RfidWriteProfile
implements ProfileService,
GenericWriteProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.generic.write.profile.GenericWriteProfile";
    public static final String DEFAULT_OPERATION_ID = "operation";
    private GenericWriteListener writeListener = new GenericWriteListener(){

        public void receiveWriteEvent(String tagId, Map tagData) {
            this.receiveWriteEvent(tagId, GenericWriteProfile.DEFAULT_OPERATION_ID, tagData);
        }

        public void receiveWriteEvent(String tagId, String operationId, Map tagData) {
            GenericWriteProfile.this.handleWriteEvent(tagId, operationId, tagData);
        }
    };
    private GenericWriteService adapter;

    public GenericWriteProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    protected void endOperations() {
        this.setOperationsStatusFinished();
    }

    protected boolean execute(String[] op_parameters) {
        if (this.adapter != null) {
            return this.adapter.execute(op_parameters);
        }
        return false;
    }

    protected boolean executeBlockErase(String[] op_parameters) {
        return this.execute(op_parameters);
    }

    protected boolean executeBlockWrite(String[] op_parameters) {
        return this.execute(op_parameters);
    }

    protected boolean executeFilter(String[] op_parameters) {
        return this.execute(op_parameters);
    }

    protected boolean executeIncrementWrite(String[] op_parameters) {
        return this.execute(op_parameters);
    }

    protected boolean executeKill(String[] op_parameters) {
        return this.execute(op_parameters);
    }

    protected boolean executeLock(String[] op_parameters) {
        return this.execute(op_parameters);
    }

    protected boolean executeRead(String[] op_parameters) {
        return this.execute(op_parameters);
    }

    protected void executeStop() {
        this.setOperationsStatusFinished();
    }

    protected boolean executeWrite(String[] op_parameters) {
        return this.execute(op_parameters);
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "GenericWriteProfile";
    }

    protected void handleWriteEvent(String tagId, Map tagData) {
        this.handleWriteEvent(tagId, DEFAULT_OPERATION_ID, tagData);
    }

    protected void handleWriteEvent(String tagId, String operationId, Map tagData) {
        String bOperationId = operationId != null && operationId.length() > 0 ? operationId : DEFAULT_OPERATION_ID;
        Map bTagData = tagData != null ? tagData : new Hashtable();
        this.notifyTagReport(tagId, bOperationId, bTagData);
    }

    private void initialize() {
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public void setWriteAdapterService(GenericWriteService adapter) {
        this.adapter = adapter;
        ((GenericWriteListenerService)adapter).setWriteListener(this.writeListener);
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("genericwriteprofile.notificationpriority", this.getNotificationPriority()));
    }

    protected boolean startOperations() {
        this.setOperationsStatusStarted();
        return true;
    }
}

