/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import java.util.LinkedList;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.transport.ChannelState;
import org.eclipse.soda.dk.transport.service.SendDataService;

public class ResponseChannelState
extends ChannelState {
    private LinkedList sendQueue = new LinkedList();
    private int pendingResponseCount = 0;
    protected SendDataService lastSendData = null;
    protected int retryCount = 0;

    public ResponseChannelState(ChannelService channel, int maxlength) {
        super(channel, maxlength);
    }

    public void addSendData(SendDataService sendData) {
        this.sendQueue.add(sendData);
    }

    public void decrementPendingResponseCount() {
        if (this.pendingResponseCount > 0) {
            --this.pendingResponseCount;
        }
    }

    public SendDataService getLastSendData() {
        return this.lastSendData;
    }

    public SendDataService getNextSendData() {
        if (this.sendQueue.isEmpty()) {
            return null;
        }
        return (SendDataService)this.sendQueue.removeFirst();
    }

    public int getPendingResponseCount() {
        return this.pendingResponseCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void incrementPendingResponseCount() {
        ++this.pendingResponseCount;
    }

    public int incrementRetryCount() {
        return this.retryCount++;
    }

    public void setLastSendData(SendDataService sendData) {
        this.lastSendData = sendData;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }
}

