/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.junit.internal.old;

import java.util.Dictionary;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.junit.internal.old.PropertiesTestCase;
import org.eclipse.soda.sat.core.junit.internal.old.service.DummyService;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.junit.util.ValueHolder;
import org.osgi.framework.BundleContext;

public class BaseBundleActivatorPropertiesTestCase
extends PropertiesTestCase {
    private static final String DEACTIVATED_BUNDLE_PREMATURELY = "Deactivated bundle prematurely";
    private static final String BUNDLE_ACTIVATION_FAILED = "Bundle activation failed";
    private static final String BUNDLE_DEACTIVATION_FAILED = "Bundle deactivation failed";
    private static final String FAILED_TO_ACQUIRE_SERVICE = "Failed to acquire DummyService";
    private BaseBundleActivator baseBundleActivator;
    private final ValueHolder activatedHolder = ValueHolder.nullValue();
    private final ValueHolder acquiredHolder = ValueHolder.nullValue();
    private final ValueHolder deactivatedHolder = ValueHolder.nullValue();
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.junit.internal.old.BaseBundleActivatorPropertiesTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BaseBundleActivatorPropertiesTestCase(String name) {
        super(name);
    }

    private void buildBaseBundleActivator() {
        this.baseBundleActivator = new BaseBundleActivator(){

            protected void activate() {
                BaseBundleActivatorPropertiesTestCase.this.activatedHolder.setTrue();
                DummyService dummy = (DummyService)this.getImportedService(DummyService.SERVICE_NAME);
                String description = dummy.getDescription();
                boolean equal = "Dummy with properties".equals(description);
                BaseBundleActivatorPropertiesTestCase.this.acquiredHolder.setValue(equal);
            }

            protected void deactivate() {
                BaseBundleActivatorPropertiesTestCase.this.deactivatedHolder.setTrue();
            }

            public String[] getImportedServiceNames() {
                String[] names = new String[]{DummyService.SERVICE_NAME};
                return names;
            }

            protected void start() {
                this.addImportedServiceFilter(DummyService.SERVICE_NAME, "(&(cn=simona)(o=OTI)(c=US))");
            }
        };
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.activatedHolder.setFalse();
        this.acquiredHolder.setFalse();
        this.deactivatedHolder.setFalse();
        this.buildBaseBundleActivator();
        this.startBundleActivator();
    }

    private void startBundleActivator() {
        BundleContext bundleContext = this.getBundleContext();
        try {
            this.baseBundleActivator.start(bundleContext);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    private void stopBundleActivator() {
        BundleContext bundleContext = this.getBundleContext();
        try {
            this.baseBundleActivator.stop(bundleContext);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        this.stopBundleActivator();
        super.tearDown();
    }

    public void testAddProperty() {
        Dictionary properties = this.recordWithProperties.getProperties();
        properties.put("state", "NC");
        this.recordWithProperties.setProperties(properties);
        Assert.assertTrue((String)DEACTIVATED_BUNDLE_PREMATURELY, (boolean)this.deactivatedHolder.isFalse());
    }

    public void testMatchingPropertyChange() {
        this.testUnmatchingPropertyChange();
        this.activatedHolder.setFalse();
        this.acquiredHolder.setFalse();
        this.deactivatedHolder.setFalse();
        Dictionary properties = this.recordWithProperties.getProperties();
        properties.put("c", "US");
        this.recordWithProperties.setProperties(properties);
        Assert.assertTrue((String)BUNDLE_ACTIVATION_FAILED, (boolean)this.activatedHolder.isTrue());
        Assert.assertTrue((String)FAILED_TO_ACQUIRE_SERVICE, (boolean)this.acquiredHolder.isTrue());
        Assert.assertTrue((String)DEACTIVATED_BUNDLE_PREMATURELY, (boolean)this.deactivatedHolder.isFalse());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveProperty() {
        Dictionary properties = this.recordWithProperties.getProperties();
        properties.remove("o");
        int level = LogUtility.getLoggingLevel();
        try {
            LogUtility.setLoggingLevel((int)1);
            this.recordWithProperties.setProperties(properties);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            LogUtility.setLoggingLevel((int)level);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        LogUtility.setLoggingLevel((int)level);
        Assert.assertTrue((String)BUNDLE_DEACTIVATION_FAILED, (boolean)this.deactivatedHolder.isTrue());
    }

    public void testSimpleCase() {
        Assert.assertTrue((String)BUNDLE_ACTIVATION_FAILED, (boolean)this.activatedHolder.isTrue());
        Assert.assertTrue((String)FAILED_TO_ACQUIRE_SERVICE, (boolean)this.acquiredHolder.isTrue());
        Assert.assertTrue((String)DEACTIVATED_BUNDLE_PREMATURELY, (boolean)this.deactivatedHolder.isFalse());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testUnmatchingPropertyChange() {
        this.testSimpleCase();
        Dictionary properties = this.recordWithProperties.getProperties();
        properties.put("c", "UK");
        int level = LogUtility.getLoggingLevel();
        try {
            LogUtility.setLoggingLevel((int)1);
            this.recordWithProperties.setProperties(properties);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            LogUtility.setLoggingLevel((int)level);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        LogUtility.setLoggingLevel((int)level);
        Assert.assertTrue((String)BUNDLE_DEACTIVATION_FAILED, (boolean)this.deactivatedHolder.isTrue());
    }
}

