/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.container;

import org.eclipse.soda.sat.core.internal.record.container.ServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IExportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IServiceRecordAction;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.eclipse.soda.sat.core.util.Assertion;

public final class ExportServiceRecordContainer
extends ServiceRecordContainer
implements IExportServiceRecordContainer {
    private static IServiceRecordAction isRegisteredAction;
    private static IServiceRecordAction registerAction;
    private static IServiceRecordAction unregisterAction;
    private boolean registered;
    static /* synthetic */ Class class$0;

    private static IServiceRecordAction createIsRegisteredAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IExportServiceRecord exportServiceRecord = (IExportServiceRecord)record;
                boolean registered = exportServiceRecord.isRegistered();
                return registered;
            }
        };
    }

    private static IServiceRecordAction createRegisterAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IExportServiceRecord exportServiceRecord = (IExportServiceRecord)record;
                exportServiceRecord.register();
                return true;
            }
        };
    }

    private static IServiceRecordAction createUnregisterAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IExportServiceRecord exportServiceRecord = (IExportServiceRecord)record;
                exportServiceRecord.unregister();
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getIsRegisteredAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ExportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (isRegisteredAction == null) {
                ExportServiceRecordContainer.setIsRegisteredAction(ExportServiceRecordContainer.createIsRegisteredAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return isRegisteredAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getRegisterAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ExportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (registerAction == null) {
                ExportServiceRecordContainer.setRegisterAction(ExportServiceRecordContainer.createRegisterAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registerAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getUnregisterAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.ExportServiceRecordContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (unregisterAction == null) {
                ExportServiceRecordContainer.setUnregisterAction(ExportServiceRecordContainer.createUnregisterAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return unregisterAction;
        }
    }

    private static void setIsRegisteredAction(IServiceRecordAction isRegisteredAction) {
        ExportServiceRecordContainer.isRegisteredAction = isRegisteredAction;
    }

    private static void setRegisterAction(IServiceRecordAction registerAction) {
        ExportServiceRecordContainer.registerAction = registerAction;
    }

    private static void setUnregisterAction(IServiceRecordAction unregisterAction) {
        ExportServiceRecordContainer.unregisterAction = unregisterAction;
    }

    public ExportServiceRecordContainer() {
        this.setRegistered(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(IExportServiceRecord record) {
        Assertion.checkArgumentIsNotNull(record, "record");
        ExportServiceRecordContainer exportServiceRecordContainer = this;
        synchronized (exportServiceRecordContainer) {
            String[] names = record.getNames();
            int count = names.length;
            int index = 0;
            boolean added = true;
            while (added && index < count) {
                String name = names[index];
                added = this.add(name, record);
                ++index;
            }
            boolean registeredRecord = record.isRegistered();
            if (!registeredRecord) {
                this.setRegistered(false);
            }
            return added;
        }
    }

    protected int createStringBufferSize() {
        return super.createStringBufferSize() + 75;
    }

    protected int createTableCapacity() {
        return 5;
    }

    private boolean getRegistered() {
        return this.registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered() {
        boolean registered;
        boolean empty = this.isEmpty();
        if (empty) {
            return false;
        }
        ExportServiceRecordContainer exportServiceRecordContainer = this;
        synchronized (exportServiceRecordContainer) {
            block5: {
                registered = this.getRegistered();
                if (!registered) break block5;
                return true;
            }
            IServiceRecordAction action = ExportServiceRecordContainer.getIsRegisteredAction();
            registered = this.doForEach(action, null);
        }
        return registered;
    }

    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        boolean registered = this.isRegistered();
        buffer.append(", registered=");
        buffer.append(registered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        ExportServiceRecordContainer exportServiceRecordContainer = this;
        synchronized (exportServiceRecordContainer) {
            boolean registered = this.getRegistered();
            if (registered) {
                return;
            }
            IServiceRecordAction action = ExportServiceRecordContainer.getRegisterAction();
            this.doForEach(action, null);
            this.setRegistered(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IExportServiceRecord record) {
        Assertion.checkArgumentIsNotNull(record, "record");
        ExportServiceRecordContainer exportServiceRecordContainer = this;
        synchronized (exportServiceRecordContainer) {
            boolean removed = true;
            String[] names = record.getNames();
            int count = names.length;
            int index = 0;
            while (removed && index < count) {
                String name = names[index];
                removed = this.remove(name, record);
                ++index;
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(String name) {
        boolean removed = true;
        ExportServiceRecordContainer exportServiceRecordContainer = this;
        synchronized (exportServiceRecordContainer) {
            IServiceRecord[] records = this.getAll(name);
            int length = records.length;
            int index = 0;
            while (removed && index < length) {
                IExportServiceRecord record = (IExportServiceRecord)records[index];
                removed = this.remove(record);
                ++index;
            }
        }
        return removed;
    }

    private void setRegistered(boolean registered) {
        this.registered = registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        ExportServiceRecordContainer exportServiceRecordContainer = this;
        synchronized (exportServiceRecordContainer) {
            IServiceRecordAction action = ExportServiceRecordContainer.getUnregisterAction();
            this.doForEach(action, null);
            this.setRegistered(false);
        }
    }
}

