/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.ServiceReferenceUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class OutputStreamLog
implements LogService {
    private static final String LOG_LEVEL_DEBUG_KEY = "Common.LogLevelDebug";
    private static final String LOG_LEVEL_ERROR_KEY = "Common.LogLevelError";
    private static final String LOG_LEVEL_INFO_KEY = "Common.LogLevelInfo";
    private static final String LOG_LEVEL_UNKNOWN_KEY = "Common.Unknown";
    private static final String LOG_LEVEL_WARNING_KEY = "Common.LogLevelWarning";
    private static final String LOG_LEVEL_DEBUG_VALUE = Messages.getString("Common.LogLevelDebug");
    private static final String LOG_LEVEL_ERROR_VALUE = Messages.getString("Common.LogLevelError");
    private static final String LOG_LEVEL_INFO_VALUE = Messages.getString("Common.LogLevelInfo");
    private static final String LOG_LEVEL_UNKNOWN_VALUE = Messages.getString("Common.Unknown");
    private static final String LOG_LEVEL_WARNING_VALUE = Messages.getString("Common.LogLevelWarning");
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private OutputStream errorOutputStream;
    private OutputStream warningOutputStream;
    private OutputStream infoOutputStream;
    private OutputStream debugOutputStream;
    private ICharBuffer buffer;

    public OutputStreamLog(OutputStream errorOutputStream, OutputStream warningOutputStream, OutputStream infoOutputStream, OutputStream debugOutputStream) {
        this.initializeOutputStreams(errorOutputStream, warningOutputStream, infoOutputStream, debugOutputStream);
        this.setBuffer(this.createBuffer());
    }

    private ICharBuffer createBuffer() {
        FactoryUtility utility = FactoryUtility.getInstance();
        ICharBuffer buffer = utility.createCharBuffer(1024);
        return buffer;
    }

    private String formatLogMessage(ServiceReference reference, int level, String message) {
        ICharBuffer buffer = this.getBuffer();
        buffer.setLength(0);
        String prefix = this.getPrefix(level);
        buffer.append(prefix);
        buffer.append(' ');
        buffer.append(message);
        this.printServiceReferenceOn(buffer, reference);
        buffer.append(LINE_SEPARATOR);
        String logMessage = buffer.toString();
        return logMessage;
    }

    private ICharBuffer getBuffer() {
        return this.buffer;
    }

    private OutputStream getDebugOutputStream() {
        return this.debugOutputStream;
    }

    private OutputStream getErrorOutputStream() {
        return this.errorOutputStream;
    }

    private OutputStream getInfoOutputStream() {
        return this.infoOutputStream;
    }

    private String getLevelText(int level) {
        String text;
        switch (level) {
            case 1: {
                text = LOG_LEVEL_ERROR_VALUE;
                break;
            }
            case 2: {
                text = LOG_LEVEL_WARNING_VALUE;
                break;
            }
            case 3: {
                text = LOG_LEVEL_INFO_VALUE;
                break;
            }
            case 4: {
                text = LOG_LEVEL_DEBUG_VALUE;
                break;
            }
            default: {
                text = LOG_LEVEL_UNKNOWN_VALUE;
            }
        }
        return text;
    }

    private OutputStream getOutputStream(int level) {
        OutputStream stream = level == 4 ? this.getDebugOutputStream() : (level == 3 ? this.getInfoOutputStream() : (level == 2 ? this.getWarningOutputStream() : (level == 1 ? this.getErrorOutputStream() : System.err)));
        return stream;
    }

    private String getPrefix(int level) {
        String levelText = this.getLevelText(level);
        FactoryUtility utility = FactoryUtility.getInstance();
        ICharBuffer buffer = utility.createCharBuffer(10);
        buffer.append('[');
        buffer.append(levelText);
        buffer.append(']');
        String prefix = buffer.toString();
        return prefix;
    }

    private List getServiceNames(ServiceReference reference) {
        ServiceReferenceUtility utility = ServiceReferenceUtility.getInstance();
        List names = utility.getServiceNames(reference);
        return names;
    }

    private OutputStream getWarningOutputStream() {
        return this.warningOutputStream;
    }

    private void initializeOutputStreams(OutputStream errorOutputStream, OutputStream warningOutputStream, OutputStream infoOutputStream, OutputStream debugOutputStream) {
        this.setErrorOutputStream(errorOutputStream);
        this.setWarningOutputStream(warningOutputStream);
        this.setInfoOutputStream(infoOutputStream);
        this.setDebugOutputStream(debugOutputStream);
    }

    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(int level, String message, Throwable throwable) {
        this.log(null, level, message, throwable);
    }

    public void log(ServiceReference reference, int level, String message) {
        this.log(reference, level, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(ServiceReference reference, int level, String message, Throwable throwable) {
        OutputStream stream = this.getOutputStream(level);
        if (stream == null) {
            return;
        }
        OutputStreamLog outputStreamLog = this;
        synchronized (outputStreamLog) {
            String logMessage = this.formatLogMessage(reference, level, message);
            byte[] bytes = logMessage.getBytes();
            try {
                stream.write(bytes);
                stream.flush();
                if (throwable != null) {
                    PrintStream printStream = new PrintStream(stream);
                    throwable.printStackTrace(printStream);
                    printStream.flush();
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    private void printServiceReferenceOn(ICharBuffer buffer, ServiceReference reference) {
        List names;
        boolean empty;
        if (reference == null) {
            return;
        }
        Bundle bundle = reference.getBundle();
        if (bundle != null) {
            String symbolicName = bundle.getSymbolicName();
            long id = bundle.getBundleId();
            buffer.append(',');
            buffer.append(' ');
            buffer.append("bundle");
            buffer.append('=');
            buffer.append(symbolicName);
            buffer.append(' ');
            buffer.append('[');
            buffer.append(id);
            buffer.append(']');
        }
        if (empty = (names = this.getServiceNames(reference)).isEmpty()) {
            return;
        }
        buffer.append(',');
        buffer.append(' ');
        buffer.append("services");
        buffer.append('=');
        buffer.append('[');
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            Object name = iterator.next();
            buffer.append(name);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append(']');
    }

    private void setBuffer(ICharBuffer buffer) {
        this.buffer = buffer;
    }

    private void setDebugOutputStream(OutputStream debugOutputStream) {
        this.debugOutputStream = debugOutputStream;
    }

    private void setErrorOutputStream(OutputStream errorOutputStream) {
        this.errorOutputStream = errorOutputStream;
    }

    private void setInfoOutputStream(OutputStream infoOutputStream) {
        this.infoOutputStream = infoOutputStream;
    }

    private void setWarningOutputStream(OutputStream warningOutputStream) {
        this.warningOutputStream = warningOutputStream;
    }
}

