/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import java.util.ArrayList;
import java.util.Dictionary;
import org.eclipse.soda.sat.core.framework.interfaces.ITokenizer;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;

public final class BundleManifestUtility {
    private static final String DEPRECATED_EXPORTED_SERVICE_HEADER_SHOULD_NOT_BE_USED_KEY = "BundleManifestUtility.DeprecatedExportedServiceHeaderShouldNotBeUsed";
    private static final String DEPRECATED_IMPORTED_SERVICE_HEADER_SHOULD_NOT_BE_USED_KEY = "BundleManifestUtility.DeprecatedImportedServiceHeaderShouldNotBeUsed";
    private static final String[] NO_STRINGS = new String[0];
    private static final BundleManifestUtility INSTANCE = new BundleManifestUtility();

    public static BundleManifestUtility getInstance() {
        return INSTANCE;
    }

    private BundleManifestUtility() {
    }

    private void checkIsEmpty(Bundle bundle, String[] values, String messageKey) {
        if (values.length == 0) {
            return;
        }
        String id = bundle.getSymbolicName();
        String message = Messages.getString(messageKey);
        LogUtility.logWarning((Object)id, message);
    }

    public String getBundleActivator(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-Activator");
        return value;
    }

    public String getBundleCategory(Bundle bundle) {
        String value = this.getHeader(bundle, "Bundle-Category");
        return value;
    }

    public String getBundleClasspath(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-ClassPath");
        return value;
    }

    public String getBundleContactAddress(Bundle bundle) {
        String value = this.getHeader(bundle, "Bundle-ContactAddress");
        return value;
    }

    public String getBundleCopyright(Bundle bundle) {
        String value = this.getHeader(bundle, "Bundle-Copyright");
        return value;
    }

    public String getBundleDescription(Bundle bundle) {
        String value = this.getHeader(bundle, "Bundle-Description");
        return value;
    }

    public String getBundleDocUrl(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-DocURL");
        return value;
    }

    public String getBundleLocalization(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-Localization");
        return value;
    }

    public String getBundleManifestVersion(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-ManifestVersion");
        return value;
    }

    public String getBundleName(Bundle bundle) {
        String value = this.getHeader(bundle, "Bundle-Name");
        return value;
    }

    public String getBundleNativeCode(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-NativeCode");
        return value;
    }

    public String[] getBundleRequiredExecutionEnvironments(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-RequiredExecutionEnvironment");
        String[] values = this.tokenizeManifestValue(value);
        return values;
    }

    public String getBundleSymbolicName(Bundle bundle) {
        String value = this.getBundleSymbolicName(bundle, true);
        return value;
    }

    public String getBundleSymbolicName(Bundle bundle, boolean includeParameters) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-SymbolicName");
        if (!includeParameters) {
            value = this.removeParameters(value);
        }
        return value;
    }

    public String getBundleUpdateLocation(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-ClassPath");
        return value;
    }

    public String getBundleVendor(Bundle bundle) {
        String value = this.getHeader(bundle, "Bundle-Vendor");
        return value;
    }

    public String getBundleVersion(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Bundle-Version");
        return value;
    }

    public String[] getDynamicImportPackages(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "DynamicImport-Package");
        String[] values = this.tokenizeManifestValue(value);
        return values;
    }

    public String[] getExportPackages(Bundle bundle) {
        String[] values = this.getExportPackages(bundle, true);
        return values;
    }

    public String[] getExportPackages(Bundle bundle, boolean includeParameters) {
        String value = this.getUnlocalizedHeader(bundle, "Export-Package");
        String[] values = this.tokenizeManifestValue(value, includeParameters);
        return values;
    }

    public String[] getExportServices(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Export-Service");
        String[] values = this.tokenizeManifestValue(value);
        this.checkIsEmpty(bundle, values, DEPRECATED_EXPORTED_SERVICE_HEADER_SHOULD_NOT_BE_USED_KEY);
        return values;
    }

    public String getFragmentHost(Bundle bundle) {
        String value = this.getFragmentHost(bundle, true);
        return value;
    }

    public String getFragmentHost(Bundle bundle, boolean includeParameters) {
        String value = this.getUnlocalizedHeader(bundle, "Fragment-Host");
        if (!includeParameters) {
            value = this.removeParameters(value);
        }
        return value;
    }

    public String getHeader(Bundle bundle, String key) {
        String locale = null;
        String value = this.getHeader(bundle, key, locale);
        return value;
    }

    public String getHeader(Bundle bundle, String key, String locale) {
        Assertion.checkArgumentIsNotNull(bundle, "bundle");
        Assertion.checkArgumentIsNotNull(key, "key");
        Dictionary headers = bundle.getHeaders(locale);
        String value = (String)headers.get(key);
        return value;
    }

    public String[] getImportPackages(Bundle bundle) {
        String[] values = this.getImportPackages(bundle, true);
        return values;
    }

    public String[] getImportPackages(Bundle bundle, boolean includeParameters) {
        String value = this.getUnlocalizedHeader(bundle, "Import-Package");
        String[] values = this.tokenizeManifestValue(value, includeParameters);
        return values;
    }

    public String[] getImportServices(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Import-Service");
        String[] values = this.tokenizeManifestValue(value);
        this.checkIsEmpty(bundle, values, DEPRECATED_IMPORTED_SERVICE_HEADER_SHOULD_NOT_BE_USED_KEY);
        return values;
    }

    public String[] getRequireBundles(Bundle bundle) {
        String[] values = this.getRequireBundles(bundle, true);
        return values;
    }

    public String[] getRequireBundles(Bundle bundle, boolean includeParameters) {
        String value = this.getUnlocalizedHeader(bundle, "Require-Bundle");
        String[] values = this.tokenizeManifestValue(value, includeParameters);
        return values;
    }

    public String[] getServiceComponents(Bundle bundle) {
        String value = this.getUnlocalizedHeader(bundle, "Service-Component");
        String[] values = this.tokenizeManifestValue(value);
        return values;
    }

    public String getUnlocalizedHeader(Bundle bundle, String key) {
        String locale = new String();
        String value = this.getHeader(bundle, key, locale);
        return value;
    }

    private String removeParameters(String value) {
        int index = value.indexOf(59);
        if (index == -1) {
            return value;
        }
        String result = value.substring(0, index);
        return result;
    }

    private String[] tokenizeManifestValue(String value) {
        String[] values = this.tokenizeManifestValue(value, true);
        return values;
    }

    private String[] tokenizeManifestValue(String value, boolean includeParameters) {
        String[] result = NO_STRINGS;
        if (value != null) {
            FactoryUtility utility = FactoryUtility.getInstance();
            ITokenizer tokenizer = utility.createTokenizer(value, ',');
            ArrayList<String> tokens = new ArrayList<String>(20);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!includeParameters) {
                    token = this.removeParameters(token);
                }
                token = token.trim();
                tokens.add(token);
            }
            int length = tokens.size();
            result = new String[length];
            tokens.toArray(result);
        }
        return result;
    }
}

