/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.framework.interfaces.IDependencyTracker;
import org.eclipse.soda.sat.core.framework.interfaces.IFileLog;
import org.eclipse.soda.sat.core.framework.interfaces.ILineReader;
import org.eclipse.soda.sat.core.framework.interfaces.ILineWriter;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceAdvisor;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.framework.interfaces.IProxyServiceHandler;
import org.eclipse.soda.sat.core.framework.interfaces.IQueue;
import org.eclipse.soda.sat.core.framework.interfaces.ITokenizer;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleActivationManager;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.ManagedServiceActivationManager;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.ManagedServiceFactoryActivationManager;
import org.eclipse.soda.sat.core.internal.record.ExportProxyServiceRecord;
import org.eclipse.soda.sat.core.internal.record.ExportServiceRecord;
import org.eclipse.soda.sat.core.internal.record.ImportServiceRecord;
import org.eclipse.soda.sat.core.internal.record.ServiceDetecter;
import org.eclipse.soda.sat.core.internal.record.container.ExportServiceRecordContainer;
import org.eclipse.soda.sat.core.internal.record.container.ImportServiceRecordContainer;
import org.eclipse.soda.sat.core.internal.util.CharBuffer;
import org.eclipse.soda.sat.core.internal.util.ConsoleLog;
import org.eclipse.soda.sat.core.internal.util.DependencyTracker;
import org.eclipse.soda.sat.core.internal.util.FileLog;
import org.eclipse.soda.sat.core.internal.util.LineReader;
import org.eclipse.soda.sat.core.internal.util.LineWriter;
import org.eclipse.soda.sat.core.internal.util.OutputStreamLog;
import org.eclipse.soda.sat.core.internal.util.Queue;
import org.eclipse.soda.sat.core.internal.util.Tokenizer;
import org.eclipse.soda.sat.core.record.container.interfaces.IExportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.interfaces.IExportProxyServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.util.Assertion;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.service.log.LogService;

public final class FactoryUtility {
    private static final FactoryUtility INSTANCE = new FactoryUtility();

    public static FactoryUtility getInstance() {
        return INSTANCE;
    }

    private FactoryUtility() {
    }

    public IBundleActivationManager createBundleActivationManager() {
        return new BundleActivationManager();
    }

    public IBundleActivationManager createBundleActivationManager(String id) {
        Assertion.checkArgumentIsNotNull(id, "id");
        return new BundleActivationManager(id);
    }

    public ICharBuffer createCharBuffer(int initialCapacity) {
        return new CharBuffer(initialCapacity);
    }

    public LogService createConsoleLog() {
        return new ConsoleLog();
    }

    public IDependencyTracker createDependencyTracker(int prerequisites, int dependents) {
        return new DependencyTracker(prerequisites, dependents);
    }

    public IExportProxyServiceRecord createExportProxyServiceRecord(BundleContext bundleContext, Class interfaceType, IProxyServiceHandler handler, Dictionary properties) {
        Assertion.checkArgumentIsNotNull(interfaceType, "interfaceType");
        Class[] interfaceTypes = new Class[]{interfaceType};
        return this.createExportProxyServiceRecord(bundleContext, interfaceTypes, handler, properties);
    }

    public IExportProxyServiceRecord createExportProxyServiceRecord(BundleContext bundleContext, Class[] interfaceTypes, IProxyServiceHandler handler, Dictionary properties) {
        return new ExportProxyServiceRecord(bundleContext, interfaceTypes, handler, properties);
    }

    public IExportServiceRecord createExportServiceRecord(BundleContext bundleContext, String name, Object service, Dictionary properties) {
        Assertion.checkArgumentIsNotNull(name, "name");
        String[] names = new String[]{name};
        return this.createExportServiceRecord(bundleContext, names, service, properties);
    }

    public IExportServiceRecord createExportServiceRecord(BundleContext bundleContext, String[] names, Object service, Dictionary properties) {
        return new ExportServiceRecord(bundleContext, names, service, properties);
    }

    public IExportServiceRecordContainer createExportServiceRecordContainer() {
        return new ExportServiceRecordContainer();
    }

    public IFileLog createFileLog(File file) {
        return new FileLog(file);
    }

    public IImportServiceRecord createImportServiceRecord(BundleContext bundleContext, String name, Filter filter) {
        return new ImportServiceRecord(bundleContext, name, filter);
    }

    public IImportServiceRecordContainer createImportServiceRecordContainer() {
        return new ImportServiceRecordContainer();
    }

    public ILineReader createLineReader(InputStream stream) {
        return new LineReader(stream);
    }

    public ILineReader createLineReader(InputStream stream, ILineReader.IAdvisor advisor) {
        return new LineReader(stream, advisor);
    }

    public ILineReader createLineReader(InputStream stream, int size) {
        return new LineReader(stream, size);
    }

    public ILineReader createLineReader(InputStream stream, int size, ILineReader.IAdvisor advisor) {
        return new LineReader(stream, size, advisor);
    }

    public ILineReader createLineReader(InputStream stream, String characterEncoding) {
        return new LineReader(stream, characterEncoding);
    }

    public ILineReader createLineReader(InputStream stream, String characterEncoding, ILineReader.IAdvisor advisor) {
        return new LineReader(stream, characterEncoding, advisor);
    }

    public ILineReader createLineReader(InputStream stream, String characterEncoding, int size) {
        return new LineReader(stream, characterEncoding, size);
    }

    public ILineReader createLineReader(InputStream stream, String characterEncoding, int size, ILineReader.IAdvisor advisor) {
        return new LineReader(stream, characterEncoding, size, advisor);
    }

    public ILineWriter createLineWriter(OutputStream stream) {
        return new LineWriter(stream);
    }

    public ILineWriter createLineWriter(OutputStream stream, int size) {
        return new LineWriter(stream, size);
    }

    public ILineWriter createLineWriter(OutputStream stream, String characterEncoding) {
        return new LineWriter(stream, characterEncoding);
    }

    public ILineWriter createLineWriter(OutputStream stream, String characterEncoding, int size) {
        return new LineWriter(stream, characterEncoding, size);
    }

    public IManagedServiceActivationManager createManagedServiceActivationManager(IManagedServiceAdvisor advisor) {
        return new ManagedServiceActivationManager(advisor);
    }

    public IManagedServiceFactoryActivationManager createManagedServiceFactoryActivationManager(String name, IManagedServiceFactoryAdvisor advisor) {
        return new ManagedServiceFactoryActivationManager(name, advisor);
    }

    public IManagedServiceFactoryActivationManager createManagedServiceFactoryActivationManager(String name, IManagedServiceFactoryAdvisor advisor, int numberOfConfigurationsHint) {
        return new ManagedServiceFactoryActivationManager(name, advisor, numberOfConfigurationsHint);
    }

    public LogService createOutputStreamLog(OutputStream errorOutputStream, OutputStream warningOutputStream, OutputStream infoOutputStream, OutputStream debugOutputStream) {
        return new OutputStreamLog(errorOutputStream, warningOutputStream, infoOutputStream, debugOutputStream);
    }

    public IQueue createQueue(int capacity) {
        return new Queue(capacity);
    }

    public IServiceDetecter createServiceDetecter(BundleContext bundleContext, String name) {
        return new ServiceDetecter(bundleContext, name);
    }

    public ITokenizer createTokenizer(String value) {
        return new Tokenizer(value);
    }

    public ITokenizer createTokenizer(String value, char delimiter) {
        return new Tokenizer(value, delimiter);
    }

    public ITokenizer createTokenizer(String value, char delimiter, int index) {
        return new Tokenizer(value, delimiter, index);
    }

    public ITokenizer createTokenizer(String value, int index) {
        return new Tokenizer(value, index);
    }
}

