/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;

public class MessageFormatter {
    private static final String PLACEHOLDER_CANNOT_BE_FOUND_KEY = "MessageFormatter.PlaceholderCannotBeFound";
    static /* synthetic */ Class class$0;

    public static String format(String pattern, Object value) {
        Object[] values = new Object[]{value};
        String message = MessageFormatter.format(pattern, values);
        return message;
    }

    public static String format(String pattern, Object[] values) {
        int last;
        int first;
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        if (values == null) {
            throw new IllegalArgumentException();
        }
        int length = pattern.length() * 2;
        FactoryUtility utility = FactoryUtility.getInstance();
        ICharBuffer buffer = utility.createCharBuffer(length);
        int index = 0;
        int copyIndex = 0;
        while ((first = pattern.indexOf(123, index)) != -1 && (last = pattern.indexOf(125, first)) != -1) {
            index = first + 1;
            if (last > first + 3) continue;
            MessageFormatter.format(pattern, values, buffer, copyIndex, first, last);
            copyIndex = last + 1;
        }
        buffer.append(pattern.substring(copyIndex));
        String message = buffer.toString();
        return message;
    }

    private static void format(String pattern, Object[] values, ICharBuffer buffer, int patternIndex, int placeholderBegin, int placeholderEnd) {
        Object chunk = pattern.substring(patternIndex, placeholderBegin);
        buffer.append(chunk);
        String number = pattern.substring(placeholderBegin + 1, placeholderEnd);
        try {
            int valueIndex = Integer.parseInt(number);
            if (valueIndex >= 0 && valueIndex < values.length) {
                chunk = values[valueIndex];
            } else {
                MessageFormatter.logPlaceholderCannotBeFoundError(pattern, valueIndex);
                chunk = pattern.substring(placeholderBegin, placeholderEnd + 1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            chunk = pattern.substring(placeholderBegin, placeholderEnd + 1);
        }
        buffer.append(chunk);
    }

    private static void logPlaceholderCannotBeFoundError(String pattern, int index) {
        String errorPattern = Messages.getString(PLACEHOLDER_CANNOT_BE_FOUND_KEY);
        String valueString = Integer.toString(index);
        Object[] values = new Object[]{valueString, pattern};
        String message = MessageFormatter.format(errorPattern, values);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.util.MessageFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LogUtility.logError(clazz, message);
    }

    private MessageFormatter() {
    }
}

