/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.internal;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.soda.sat.plugin.ui.internal.HandyDialog;
import org.eclipse.soda.sat.plugin.ui.util.IHandyTextDialog;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HandyTextDialog
extends HandyDialog
implements IHandyTextDialog {
    private String label;
    private int labelWidth;
    private String text;
    private Text textControl;
    private Font textControlFont;
    private FontData textControlFontData;
    private int textControlStyle;
    private IHandyTextDialog.ITextValidator textValidator;

    public HandyTextDialog(Shell parentShell) {
        super(parentShell);
    }

    private void addLabelControl(Composite parent) {
        String label = this.getLabel();
        if (label == null) {
            return;
        }
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 2;
        Label labelControl = new Label(parent, 0);
        labelControl.setText(String.valueOf(label) + ':');
        int average = this.getAverageCharWidth(labelControl);
        int width = average * label.length();
        this.setLabelWidth(width);
    }

    private void addTextControl(Composite parent) {
        int style = this.getTextControlStyle();
        style |= 0x800;
        boolean multiLine = this.isMultiLine();
        if (multiLine) {
            style |= 0x200;
        }
        Text text = new Text(parent, style);
        this.setTextControl(text);
        Font font = this.getTextControlFont();
        text.setFont(font);
        Color color = this.getBackgroundColor();
        text.setBackground(color);
        ModifyListener modifyListener = this.createTextControlModifyListener();
        if (modifyListener != null) {
            text.addModifyListener(modifyListener);
        }
        int verticalAlignment = multiLine ? 4 : 1;
        boolean grabExcessVerticalSpace = multiLine;
        GridData gridData = new GridData(4, verticalAlignment, true, grabExcessVerticalSpace);
        text.setLayoutData((Object)gridData);
    }

    private Font basicGetTextControlFont() {
        return this.textControlFont;
    }

    protected void buttonPressed(int buttonId) {
        if (17 == buttonId) {
            this.helpPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void create() {
        super.create();
        this.initialize();
        this.handleTextControlModification();
    }

    protected void createArea(Composite composite) {
        this.addLabelControl(composite);
        this.addTextControl(composite);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createOkButtonForButtonBar(parent);
        this.createCancelButtonForButtonBar(parent);
        this.createHelpButtonForButtonBar(parent);
    }

    private void createCancelButtonForButtonBar(Composite parent) {
        boolean readOnly = this.isReadOnly();
        if (readOnly) {
            return;
        }
        this.createButton(parent, 1, String.valueOf('&') + IDialogConstants.CANCEL_LABEL, false);
    }

    private void createOkButtonForButtonBar(Composite parent) {
        this.createButton(parent, 0, String.valueOf('&') + IDialogConstants.OK_LABEL, true);
    }

    private Font createTextControlFont() {
        Font font = null;
        FontData data = this.getTextControlFontData();
        if (data != null) {
            Shell shell = this.getShell();
            Display device = shell.getDisplay();
            font = new Font((Device)device, data);
        }
        return font;
    }

    private ModifyListener createTextControlModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                HandyTextDialog.this.handleTextControlModification();
            }
        };
    }

    private IHandyTextDialog.ITextValidator createTextValidator() {
        return new IHandyTextDialog.ITextValidator(){

            public boolean isValid(String value) {
                return HandyTextDialog.this.isValid(value);
            }
        };
    }

    private void disposeResources() {
        this.disposeTextControlFont();
    }

    private void disposeTextControlFont() {
        Font font = this.basicGetTextControlFont();
        if (font == null) {
            return;
        }
        font.dispose();
        this.setTextControlFont(null);
    }

    private int getAverageCharWidth(Label label) {
        GC gc = new GC((Drawable)label);
        FontMetrics metrics = gc.getFontMetrics();
        int average = metrics.getAverageCharWidth();
        gc.dispose();
        return average;
    }

    private Color getBackgroundColor() {
        UiUtility utility = UiUtility.getInstance();
        Color color = utility.getBackgroundColor();
        return color;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x += this.getLabelWidth();
        return size;
    }

    private String getLabel() {
        return this.label;
    }

    private int getLabelWidth() {
        return this.labelWidth;
    }

    private Button getOkButton() {
        return this.getButton(0);
    }

    public String getText() {
        return this.text;
    }

    private Text getTextControl() {
        return this.textControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Font getTextControlFont() {
        HandyTextDialog handyTextDialog = this;
        synchronized (handyTextDialog) {
            if (this.textControlFont == null) {
                Font font = this.createTextControlFont();
                this.setTextControlFont(font);
            }
        }
        return this.textControlFont;
    }

    private FontData getTextControlFontData() {
        return this.textControlFontData;
    }

    private int getTextControlStyle() {
        return this.textControlStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHandyTextDialog.ITextValidator getTextValidator() {
        HandyTextDialog handyTextDialog = this;
        synchronized (handyTextDialog) {
            if (this.textValidator == null) {
                IHandyTextDialog.ITextValidator validator = this.createTextValidator();
                this.setTextValidator(validator);
            }
        }
        return this.textValidator;
    }

    protected void handleTextControlModification() {
        Text text = this.getTextControl();
        String value = text.getText();
        IHandyTextDialog.ITextValidator validator = this.getTextValidator();
        boolean valid = validator.isValid(value);
        Button control = this.getOkButton();
        control.setEnabled(valid);
    }

    private void initialize() {
        String text = this.getText();
        if (text == null) {
            return;
        }
        Text textControl = this.getTextControl();
        textControl.setText(text);
        boolean readOnly = this.isReadOnly();
        if (readOnly) {
            return;
        }
        int length = text.length();
        textControl.setSelection(length, length);
    }

    private void initializeShellStyle() {
        int style = this.getShellStyle();
        boolean multiLine = this.isMultiLine();
        if (multiLine) {
            style |= 0x410;
        }
        this.setShellStyle(style);
    }

    private boolean isMultiLine() {
        return this.isTextStyleSet(2);
    }

    private boolean isReadOnly() {
        return this.isTextStyleSet(8);
    }

    private boolean isTextStyleSet(int style) {
        int textStyle = this.getTextControlStyle();
        int bit = textStyle & style;
        boolean result = bit != 0;
        return result;
    }

    protected boolean isValid(String value) {
        return true;
    }

    protected void okPressed() {
        Text textControl = this.getTextControl();
        String value = textControl.getText();
        this.setText(value);
        super.okPressed();
    }

    public int open() {
        this.initializeShellStyle();
        int result = super.open();
        this.disposeResources();
        return result;
    }

    protected void postCreateArea(Composite composite) {
        super.postCreateArea(composite);
        this.updateTextControlFont();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private void setLabelWidth(int labelWidth) {
        this.labelWidth = labelWidth;
    }

    public void setText(String text) {
        this.text = text;
    }

    private void setTextControl(Text textControl) {
        this.textControl = textControl;
    }

    private void setTextControlFont(Font textControlFont) {
        this.textControlFont = textControlFont;
    }

    public void setTextControlFont(String name, int height, int style) {
        FontData data = new FontData(name, height, style);
        this.setTextControlFontData(data);
    }

    private void setTextControlFontData(FontData textControlFontData) {
        this.textControlFontData = textControlFontData;
    }

    public void setTextControlStyle(int textControlStyle) {
        this.textControlStyle = textControlStyle;
    }

    public void setTextValidator(IHandyTextDialog.ITextValidator textValidator) {
        this.textValidator = textValidator;
    }

    private void updateTextControlFont() {
        Text text = this.getTextControl();
        Font font = this.getTextControlFont();
        text.setFont(font);
    }
}

