/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.ui.internal;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.soda.sat.plugin.AboutExtension;
import org.eclipse.soda.sat.plugin.ui.internal.AboutDataTableLabelProvider;
import org.eclipse.soda.sat.plugin.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.soda.sat.plugin.util.FakeQualiferGenerator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String ABOUT_TAB_KEY = "SatPreferencePage.AboutTab";
    private static final String ABOUT_TAB_DATE_KEY = "SatPreferencePage.AboutTabDate";
    private static final String ABOUT_TAB_DESCRIPTION_KEY = "SatPreferencePage.AboutTabDescription";
    private static final String ABOUT_TAB_TITLE_KEY = "SatPreferencePage.AboutTabTitle";
    private static final String COPY_KEY = "SatPreferencePage.Copy";
    private static final String DESCRIPTION_KEY = "SatPreferencePage.Description";
    private static final String PLUGINS_TAB_KEY = "SatPreferencePage.PluginsTab";
    private static final String PLUGINS_TAB_DESCRIPTION_KEY = "SatPreferencePage.PluginsTabDescription";
    private static final String PLUGINS_TAB_TABLE_COLUMN_ID_KEY = "SatPreferencePage.PluginsTabTableColumnId";
    private static final String PLUGINS_TAB_TABLE_COLUMN_NAME_KEY = "SatPreferencePage.PluginsTabTableColumnName";
    private static final String PLUGINS_TAB_TABLE_COLUMN_PROVIDER_KEY = "SatPreferencePage.PluginsTabTableColumnProvider";
    private static final String PLUGINS_TAB_TABLE_COLUMN_VERSION_KEY = "SatPreferencePage.PluginsTabTableColumnVersion";
    private static final String PLUGINS_TAB_TEXT_DESCRIPTION_KEY = "SatPreferencePage.PluginsTabTextDescription";
    private static final String SELECT_ALL_KEY = "SatPreferencePage.SelectAll";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.ui.preferences";
    private static final String NO_DESCRIPTION = new String();
    private static final String QUALIFIER = "qualifier";
    private Color backgroundColor;
    private Text descriptionText;

    public SatPreferencePage() {
        String description = String.valueOf(Messages.getString(DESCRIPTION_KEY)) + ':';
        this.setDescription(description);
    }

    private void addDescriptionText(Composite parent) {
        int style = 72;
        Text text = new Text(parent, style);
        String description = Messages.getString(ABOUT_TAB_DESCRIPTION_KEY);
        text.setText(description);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        text.setLayoutData((Object)gridData);
    }

    private Label addLabel(Composite parent, String value) {
        Label label = new Label(parent, 0);
        label.setText(value);
        return label;
    }

    private void addPluginDescription(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.addSeparator(composite);
        Label label = new Label(composite, 0);
        String description = String.valueOf(Messages.getString(PLUGINS_TAB_TEXT_DESCRIPTION_KEY)) + ':';
        label.setText(description);
        int style = 2634;
        Text text = new Text(composite, style);
        GridData data = new GridData(1808);
        text.setLayoutData((Object)data);
        Color color = this.getBackgroundColor();
        text.setBackground(color);
        this.setDescriptionText(text);
    }

    private void addPluginDetailsComposite(Composite parent) {
        SashForm composite = new SashForm(parent, 512);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.addPluginTable((Composite)composite);
        this.addPluginDescription((Composite)composite);
        int[] weights = new int[]{75, 25};
        composite.setWeights(weights);
    }

    private void addPluginTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        int style = 67586;
        TableViewer viewer = new TableViewer(composite, style);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        String text = Messages.getString(PLUGINS_TAB_TABLE_COLUMN_NAME_KEY);
        column.setText(text);
        column = new TableColumn(table, 0);
        text = Messages.getString(PLUGINS_TAB_TABLE_COLUMN_PROVIDER_KEY);
        column.setText(text);
        column = new TableColumn(table, 0);
        text = Messages.getString(PLUGINS_TAB_TABLE_COLUMN_VERSION_KEY);
        column.setText(text);
        column = new TableColumn(table, 0);
        text = Messages.getString(PLUGINS_TAB_TABLE_COLUMN_ID_KEY);
        column.setText(text);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        viewer.setLabelProvider((IBaseLabelProvider)new AboutDataTableLabelProvider());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        List<AboutExtension> extensions = this.getAboutExtensions();
        Comparator<AboutExtension> comparator = this.createAboutExtensionComparator();
        Collections.sort(extensions, comparator);
        viewer.setInput(extensions);
        ControlListener controlListener = this.createTableControlListener(table);
        composite.addControlListener(controlListener);
        KeyAdapter keyListener = this.createTableKeyListener(table);
        table.addKeyListener((KeyListener)keyListener);
        ISelectionChangedListener selectionChangedListener = this.createTableViewerSelectionChangedListener();
        viewer.addSelectionChangedListener(selectionChangedListener);
        Color color = table.getBackground();
        this.setBackgroundColor(color);
        Menu menu = this.createPluginTableMenu(table);
        table.setMenu(menu);
        this.packTable(table);
    }

    private void addPluginTitle(Composite parent) {
        Label label = new Label(parent, 64);
        String title = String.valueOf(Messages.getString(PLUGINS_TAB_DESCRIPTION_KEY)) + ':';
        label.setText(title);
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 266);
        GridData data = new GridData(768);
        separator.setLayoutData((Object)data);
    }

    private void addTitleComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label imageLabel = new Label(composite, 0);
        Image satImage = this.getImage("sat");
        imageLabel.setImage(satImage);
        String title = this.getTabTitle();
        Label titleLabel = this.addLabel(composite, title);
        Menu menu = this.createTitleMenu(title);
        imageLabel.setMenu(menu);
        titleLabel.setMenu(menu);
    }

    private int calculateRemainingHorizontalSpace(Table table) {
        Composite parent = table.getParent();
        Rectangle area = parent.getClientArea();
        int width = area.width;
        int tableBorderWidth = table.getBorderWidth();
        width -= tableBorderWidth * 2;
        GridLayout layout = (GridLayout)parent.getLayout();
        width -= layout.marginWidth * 2;
        Rectangle bounds = table.getBounds();
        if (bounds.height > area.height) {
            ScrollBar scrollbar = table.getVerticalBar();
            Point scrollbarSize = scrollbar.getSize();
            width -= scrollbarSize.x;
        }
        TableColumn[] columns = table.getColumns();
        int count = columns.length;
        int cumulative = 0;
        int i = 0;
        while (i < count - 1) {
            TableColumn column = columns[i];
            int columnWidth = column.getWidth();
            cumulative += columnWidth;
            ++i;
        }
        int remainder = width - cumulative;
        return remainder;
    }

    private void copyToClipboard(String value) {
        UiUtility utility = UiUtility.getInstance();
        utility.copyToClipboard(value);
    }

    private Control createAboutControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.addTitleComposite(composite);
        this.addDescriptionText(composite);
        return composite;
    }

    private Comparator<AboutExtension> createAboutExtensionComparator() {
        return new Comparator<AboutExtension>(){

            @Override
            public int compare(AboutExtension left, AboutExtension right) {
                String leftName = left.getPluginName();
                String rightName = right.getPluginName();
                int compare = leftName.compareTo(rightName);
                return compare;
            }
        };
    }

    private void createAboutTab(TabFolder folder) {
        Control control = this.createAboutControl((Composite)folder);
        String label = Messages.getString(ABOUT_TAB_KEY);
        this.createTabItem(folder, label, control);
    }

    protected Control createContents(Composite parent) {
        UiUtility utility = UiUtility.getInstance();
        utility.setHelp((Control)parent, HELP_CONTEXT_ID);
        this.noDefaultAndApplyButton();
        TabFolder folder = new TabFolder(parent, 0);
        this.createAboutTab(folder);
        this.createPluginTab(folder);
        Dialog.applyDialogFont((Control)parent);
        return folder;
    }

    private SelectionListener createCopySelectionToClipboardSelectionListener(final Table table) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SatPreferencePage.this.handleCopySelectionToClipboard(table);
            }
        };
    }

    private SelectionListener createCopyToClipboardSelectionListener(final String value) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SatPreferencePage.this.copyToClipboard(value);
            }
        };
    }

    private String createMenuItemText(String textKey, int accelerator) {
        String acceleratorText = Action.convertAccelerator((int)accelerator);
        StringBuffer buffer = new StringBuffer(25);
        String text = Messages.getString(textKey);
        buffer.append(text);
        buffer.append('\t');
        buffer.append(acceleratorText);
        String value = buffer.toString();
        return value;
    }

    private Control createPluginControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        this.addPluginTitle(composite);
        this.addPluginDetailsComposite(composite);
        return composite;
    }

    private void createPluginTab(TabFolder folder) {
        Control control = this.createPluginControl((Composite)folder);
        String label = Messages.getString(PLUGINS_TAB_KEY);
        this.createTabItem(folder, label, control);
    }

    private Menu createPluginTableMenu(Table table) {
        Shell control = this.getShell();
        Menu menu = new Menu((Control)control);
        MenuItem menuItem = new MenuItem(menu, 0);
        Image copyImage = this.getImage("copy");
        menuItem.setImage(copyImage);
        String menuText = this.createMenuItemText(COPY_KEY, 262211);
        menuItem.setText(menuText);
        SelectionListener listener = this.createCopySelectionToClipboardSelectionListener(table);
        menuItem.addSelectionListener(listener);
        menuItem = new MenuItem(menu, 0);
        menuText = this.createMenuItemText(SELECT_ALL_KEY, 262209);
        menuItem.setText(menuText);
        listener = this.createSelectAllSelectionListener(table);
        menuItem.addSelectionListener(listener);
        return menu;
    }

    private SelectionListener createSelectAllSelectionListener(final Table table) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                table.selectAll();
            }
        };
    }

    private void createTabItem(TabFolder folder, String text, Control control) {
        TabItem item = new TabItem(folder, 0);
        item.setText(text);
        item.setControl(control);
    }

    private ControlListener createTableControlListener(final Table table) {
        return new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                SatPreferencePage.this.handleTableResized(table);
            }
        };
    }

    private KeyAdapter createTableKeyListener(final Table table) {
        return new KeyAdapter(){

            private boolean isCtrlKeyDown(KeyEvent event) {
                return (event.stateMask & 0x40000) != 0;
            }

            public void keyReleased(KeyEvent event) {
                boolean ctrlKeyDown = this.isCtrlKeyDown(event);
                if (!ctrlKeyDown) {
                    return;
                }
                char key = (char)event.keyCode;
                if ((key = Character.toLowerCase(key)) != 'c') {
                    return;
                }
                SatPreferencePage.this.handleCopySelectionToClipboard(table);
            }
        };
    }

    private ISelectionChangedListener createTableViewerSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SatPreferencePage.this.handleTableViewerSelectionChanged(event);
            }
        };
    }

    private Menu createTitleMenu(String title) {
        Shell control = this.getShell();
        Menu menu = new Menu((Control)control);
        MenuItem menuItem = new MenuItem(menu, 0);
        Image copyImage = this.getImage("copy");
        menuItem.setImage(copyImage);
        String menuText = Messages.getString(COPY_KEY);
        menuItem.setText(menuText);
        SelectionListener listener = this.createCopyToClipboardSelectionListener(title);
        menuItem.addSelectionListener(listener);
        return menu;
    }

    private List<AboutExtension> getAboutExtensions() {
        org.eclipse.soda.sat.plugin.bundle.Activator activator = org.eclipse.soda.sat.plugin.bundle.Activator.getDefault();
        List extensions = activator.getAboutExtensions();
        return extensions;
    }

    private Color getBackgroundColor() {
        return this.backgroundColor;
    }

    private String getBundleVersion() {
        Activator activator = Activator.getDefault();
        Bundle bundle = activator.getBundle();
        Dictionary headers = bundle.getHeaders();
        String value = (String)headers.get("Bundle-Version");
        return value;
    }

    private Text getDescriptionText() {
        return this.descriptionText;
    }

    private Image getImage(String filename) {
        Activator activator = Activator.getDefault();
        Image image = activator.getImage(filename);
        return image;
    }

    private String getTabTitle() {
        StringBuffer buffer = new StringBuffer(25);
        String title = Messages.getString(ABOUT_TAB_TITLE_KEY);
        buffer.append(title);
        String value = this.getBundleVersion();
        int index = value.lastIndexOf(46);
        if (index != -1) {
            int qualifierLength;
            buffer.append(' ');
            String version = value.substring(0, index);
            buffer.append(version);
            String qualifier = value.substring(index + 1);
            if (QUALIFIER.equals(qualifier)) {
                FakeQualiferGenerator generator = new FakeQualiferGenerator();
                qualifier = generator.generate();
            }
            if ((qualifierLength = qualifier.length()) == 12) {
                String year = qualifier.substring(0, 4);
                String month = qualifier.substring(4, 6);
                String day = qualifier.substring(6, 8);
                String pattern = Messages.getString(ABOUT_TAB_DATE_KEY);
                Object[] values = new Object[]{year, month, day};
                String date = MessageFormat.format(pattern, values);
                buffer.append(date);
            }
        }
        String result = buffer.toString();
        return result;
    }

    private void handleCopySelectionToClipboard(Table table) {
        TableItem[] items = table.getSelection();
        int size = items.length;
        StringBuffer buffer = new StringBuffer(size * 125);
        int i = 0;
        while (i < size) {
            TableItem item = items[i];
            AboutExtension aboutExtension = (AboutExtension)item.getData();
            this.printAboutExtensionOn(buffer, aboutExtension);
            ++i;
        }
        String value = buffer.toString();
        this.copyToClipboard(value);
    }

    private void handleTableResized(Table table) {
        int width = this.calculateRemainingHorizontalSpace(table);
        TableColumn[] columns = table.getColumns();
        int count = columns.length;
        TableColumn column = columns[count - 1];
        column = columns[count - 1];
        column.setWidth(width);
    }

    private void handleTableViewerSelectionChanged(SelectionChangedEvent event) {
        String description;
        ISelection selection = event.getSelection();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        int size = structuredSelection.size();
        if (size == 1) {
            Object item = structuredSelection.getFirstElement();
            AboutExtension data = (AboutExtension)item;
            description = data.getDescription();
        } else {
            description = NO_DESCRIPTION;
        }
        Text text = this.getDescriptionText();
        text.setText(description);
    }

    public void init(IWorkbench workbench) {
    }

    private void packTable(Table table) {
        Dialog.applyDialogFont((Control)table);
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length - 1) {
            TableColumn column = columns[i];
            column.pack();
            ++i;
        }
    }

    public boolean performOk() {
        return true;
    }

    private void printAboutExtensionOn(StringBuffer buffer, AboutExtension aboutExtension) {
        String delimiter = ", ";
        String lineSeparator = System.getProperty("line.separator");
        String pluginName = aboutExtension.getPluginName();
        String providerName = aboutExtension.getProviderName();
        String version = aboutExtension.getVersion();
        String pluginId = aboutExtension.getPluginId();
        buffer.append(pluginName);
        buffer.append(delimiter);
        buffer.append(providerName);
        buffer.append(delimiter);
        buffer.append(version);
        buffer.append(delimiter);
        buffer.append(pluginId);
        buffer.append(lineSeparator);
    }

    private void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    private void setDescriptionText(Text descriptionText) {
        this.descriptionText = descriptionText;
    }
}

