/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.AEADSecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaAEADSecretKeyEncryptorBuilder
implements AEADSecretKeyEncryptorBuilder {
    private int aeadAlgorithm;
    private int symmetricAlgorithm;
    private S2K.Argon2Params argon2Params;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JceAEADUtil aeadUtil = new JceAEADUtil(this.helper);

    public JcaAEADSecretKeyEncryptorBuilder(int n, int n2, S2K.Argon2Params argon2Params) {
        this.aeadAlgorithm = n;
        this.symmetricAlgorithm = n2;
        this.argon2Params = argon2Params;
    }

    public JcaAEADSecretKeyEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadUtil = new JceAEADUtil(this.helper);
        return this;
    }

    public JcaAEADSecretKeyEncryptorBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.aeadUtil = new JceAEADUtil(this.helper);
        return this;
    }

    @Override
    public PBESecretKeyEncryptor build(char[] cArray, final PublicKeyPacket publicKeyPacket) {
        return new PBESecretKeyEncryptor(this, this.symmetricAlgorithm, this.aeadAlgorithm, this.argon2Params, new SecureRandom(), cArray){
            private byte[] iv;
            final /* synthetic */ JcaAEADSecretKeyEncryptorBuilder this$0;
            {
                this.this$0 = jcaAEADSecretKeyEncryptorBuilder;
                super(n, n2, argon2Params, secureRandom, cArray);
                this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
                this.random.nextBytes(this.iv);
            }

            @Override
            public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, int n, int n2) throws PGPException {
                try {
                    return JceAEADUtil.processAeadKeyData(this.this$0.aeadUtil, 1, this.encAlgorithm, this.aeadAlgorithm, this.getKey(), this.iv, publicKeyPacket.getPacketTag() == 6 ? 5 : 7, publicKeyPacket.getVersion(), byArray2, n, n2, publicKeyPacket.getEncodedContents());
                }
                catch (Exception exception) {
                    throw new PGPException("Exception AEAD protecting private key material", exception);
                }
            }

            @Override
            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

