/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.equinox.internal.transforms.TransformerHook;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

class ReplaceTransformer {
    static final String TYPE = "replace";
    private final TransformerHook hook;

    ReplaceTransformer(TransformerHook hook) {
        this.hook = hook;
    }

    public InputStream getInputStream(InputStream inputStream, URL transformerUrl) {
        try {
            return transformerUrl.openStream();
        }
        catch (IOException e) {
            this.hook.log(2, String.format("Can't replace resource with %s", transformerUrl), e);
            return null;
        }
    }

    public static void register(BundleContext context, TransformerHook transformerHook) {
        context.registerService(Object.class, (Object)new ReplaceTransformer(transformerHook), FrameworkUtil.asDictionary(Map.of("equinox.transformerType", TYPE)));
    }
}

