/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.typechecker.AssignmentUniquenessChecker;
import org.eclipse.escet.cif.typechecker.CifTypeCheckerProblemReporter;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class AssignmentPostChecker {
    public void check(ComplexComponent comp, CifPostCheckEnv env) {
        this.check((List<IoDecl>)comp.getIoDecls(), env);
        if (comp instanceof Group) {
            Group group = (Group)comp;
            for (Component child : group.getComponents()) {
                this.check((ComplexComponent)child, env);
            }
        } else if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            this.check(aut, env);
        }
    }

    private void check(Automaton aut, CifPostCheckEnv env) {
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                try {
                    for (Update update : edge.getUpdates()) {
                        this.check(update, (ComplexComponent)aut, UpdateContext.EDGE_UPDATE, env);
                    }
                    Map asgnMap = Maps.map();
                    AssignmentUniquenessChecker.checkUniqueAsgns((List<Update>)edge.getUpdates(), (Map<Declaration, Set<Pair<Position, List<Object>>>>)asgnMap, (CifTypeCheckerProblemReporter)env, ErrMsg.DUPL_VAR_ASGN_EDGE);
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }
        }
    }

    private void check(List<IoDecl> ioDecls, CifPostCheckEnv env) {
        for (IoDecl ioDecl : ioDecls) {
            SvgIn svgIn;
            if (!(ioDecl instanceof SvgIn) || (svgIn = (SvgIn)ioDecl).getUpdates().isEmpty()) continue;
            try {
                for (Update update : svgIn.getUpdates()) {
                    this.check(update, (ComplexComponent)svgIn.eContainer(), UpdateContext.SVG_UPDATE, env);
                }
                Map asgnMap = Maps.map();
                AssignmentUniquenessChecker.checkUniqueAsgns((List<Update>)svgIn.getUpdates(), (Map<Declaration, Set<Pair<Position, List<Object>>>>)asgnMap, (CifTypeCheckerProblemReporter)env, ErrMsg.DUPL_VAR_ASGN_SVG);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void check(Update update, ComplexComponent scope, UpdateContext context, CifPostCheckEnv env) {
        if (update instanceof Assignment) {
            Assignment assignment = (Assignment)update;
            Expression addr = assignment.getAddressable();
            if (context == UpdateContext.EDGE_UPDATE) {
                this.checkEdgeAddressable(addr, scope, env);
                return;
            } else {
                if (context != UpdateContext.SVG_UPDATE) throw new RuntimeException("Update needs either edge context or SVG context.");
                this.checkSvgAddressable(addr, env);
            }
            return;
        } else {
            if (!(update instanceof IfUpdate)) throw new RuntimeException("Unknown update: " + String.valueOf(update));
            IfUpdate ifUpdate = (IfUpdate)update;
            this.checkIfUpdate(ifUpdate, scope, context, env);
        }
    }

    private void checkIfUpdate(IfUpdate update, ComplexComponent scope, UpdateContext context, CifPostCheckEnv env) {
        for (Update then : update.getThens()) {
            this.check(then, scope, context, env);
        }
        for (Update els : update.getElses()) {
            this.check(els, scope, context, env);
        }
        for (ElifUpdate elif : update.getElifs()) {
            for (Update then : elif.getThens()) {
                this.check(then, scope, context, env);
            }
        }
    }

    private void checkEdgeAddressable(Expression addr, ComplexComponent scope, CifPostCheckEnv env) {
        Assert.check((boolean)(scope instanceof Automaton));
        for (Expression expr : CifAddressableUtils.getRefExprs((Expression)addr)) {
            DiscVariable var;
            if (expr instanceof DiscVariableExpression) {
                DiscVariableExpression dvarExpr = (DiscVariableExpression)expr;
                var = dvarExpr.getVariable();
            } else if (expr instanceof ContVariableExpression) {
                ContVariableExpression cvarExpr = (ContVariableExpression)expr;
                Assert.check((!cvarExpr.isDerivative() ? 1 : 0) != 0);
                var = cvarExpr.getVariable();
            } else {
                if (expr instanceof ReceivedExpression) {
                    throw new RuntimeException("Parser doesn't allow this.");
                }
                PositionObject obj = CifScopeUtils.getRefObjFromRef((Expression)expr);
                env.addProblem(ErrMsg.RESOLVE_NON_ASGN_VAR, expr.getPosition(), CifTextUtils.getAbsName((PositionObject)obj));
                throw new SemanticException();
            }
            EObject varParent = var.eContainer();
            Assert.check((boolean)(varParent instanceof ComplexComponent));
            if (varParent != scope) {
                env.addProblem(ErrMsg.ASGN_NON_LOCAL_VAR, expr.getPosition(), CifTextUtils.getAbsName((PositionObject)var), CifTextUtils.getAbsName((PositionObject)scope));
            }
            this.checkForStringProjection(expr, (Declaration)var, env);
        }
    }

    private void checkSvgAddressable(Expression addr, CifPostCheckEnv env) {
        for (Expression expr : CifAddressableUtils.getRefExprs((Expression)addr)) {
            if (!(expr instanceof InputVariableExpression)) {
                PositionObject obj = CifScopeUtils.getRefObjFromRef((Expression)expr);
                env.addProblem(ErrMsg.RESOLVE_NON_SVG_ASGN_VAR, expr.getPosition(), CifTextUtils.getAbsName((PositionObject)obj));
                throw new SemanticException();
            }
            InputVariableExpression ivexpr = (InputVariableExpression)expr;
            InputVariable var = ivexpr.getVariable();
            this.checkForStringProjection(expr, (Declaration)var, env);
        }
    }

    private void checkForStringProjection(Expression expr, Declaration var, CifPostCheckEnv env) {
        PositionObject varAncestor = (PositionObject)expr.eContainer();
        while (varAncestor instanceof ProjectionExpression) {
            ProjectionExpression proj = (ProjectionExpression)varAncestor;
            CifType type = proj.getChild().getType();
            CifType ntype = CifTypeUtils.normalizeType((CifType)type);
            if (ntype instanceof StringType) {
                env.addProblem(ErrMsg.ASGN_STRING_PROJ, varAncestor.getPosition(), CifTextUtils.getAbsName((PositionObject)var));
            }
            varAncestor = (PositionObject)varAncestor.eContainer();
        }
    }

    static enum UpdateContext {
        SVG_UPDATE,
        EDGE_UPDATE;

    }
}

