/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.RealDistribution;
import org.eclipse.escet.common.java.Strings;

public class NormalDistribution
extends RealDistribution {
    private final CifRandomGenerator randGen;
    protected final double mean;
    protected final double variance;
    protected final double sqrtVariance;
    private double cachedValue;
    private double cachedY;
    private boolean cacheFilled = false;

    public NormalDistribution(CifRandomGenerator randGen, double mean, double variance) {
        this.randGen = randGen;
        this.mean = mean;
        this.variance = variance;
        this.sqrtVariance = Math.sqrt(variance);
        if (variance <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The variance parameter (the second parameter) is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    protected NormalDistribution(NormalDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.mean = distribution.mean;
        this.variance = distribution.variance;
        this.sqrtVariance = distribution.sqrtVariance;
        this.cachedValue = distribution.cachedValue;
        this.cachedY = distribution.cachedY;
        this.cacheFilled = distribution.cacheFilled;
    }

    @Override
    public RealDistribution copy() {
        return new NormalDistribution(this);
    }

    @Override
    public double sample() {
        double s2;
        double s1;
        double w;
        if (this.cacheFilled) {
            this.cacheFilled = false;
            return this.mean + this.sqrtVariance * this.cachedValue * this.cachedY;
        }
        while ((w = (s1 = 2.0 * this.randGen.draw() - 1.0) * s1 + (s2 = 2.0 * this.randGen.draw() - 1.0) * s2) >= 1.0 || w == 0.0) {
        }
        this.cachedY = Math.sqrt(-2.0 * Math.log(w) / w);
        this.cachedValue = s2;
        this.cacheFilled = true;
        return this.mean + this.sqrtVariance * s1 * this.cachedY;
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"normal(%s, %s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.mean), CifSimulatorMath.realToStr(this.variance)});
    }
}

