/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.automata.impl.EdgeEventImpl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimMonitors
extends CifWalker
implements CifToCifTransformation {
    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating monitors from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
    }

    public void transform(Automaton aut) {
        Specification spec = CifScopeUtils.getSpecRoot((PositionObject)aut);
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating monitors from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkAutomaton(aut);
    }

    protected void walkAutomaton(Automaton aut) {
        Monitors monitors = aut.getMonitors();
        if (monitors == null) {
            return;
        }
        Set monitorEvents = CifEventUtils.getMonitors((Automaton)aut, null);
        for (Location loc : aut.getLocations()) {
            for (Event monitorEvent : monitorEvents) {
                EdgeEvent edgeEvent2;
                List edges = Lists.list();
                block2: for (Edge edge : loc.getEdges()) {
                    for (EdgeEvent edgeEvent2 : edge.getEvents()) {
                        Event event;
                        Expression eventRef;
                        if (edgeEvent2.getClass() != EdgeEventImpl.class || (eventRef = edgeEvent2.getEvent()) instanceof TauExpression || (event = ((EventExpression)eventRef).getEvent()) != monitorEvent) continue;
                        edges.add(edge);
                        continue block2;
                    }
                }
                List<Expression> guards = this.edgesToGuards(edges);
                if (guards == null) continue;
                EventExpression eventRef = CifConstructors.newEventExpression();
                eventRef.setType((CifType)CifConstructors.newBoolType());
                eventRef.setEvent(monitorEvent);
                edgeEvent2 = CifConstructors.newEdgeEvent();
                edgeEvent2.setEvent((Expression)eventRef);
                Edge edge = CifConstructors.newEdge();
                edge.getEvents().add((Object)edgeEvent2);
                edge.getGuards().addAll(guards);
                loc.getEdges().add((Object)edge);
            }
        }
        aut.setMonitors(null);
    }

    private List<Expression> edgesToGuards(List<Edge> edges) {
        if (edges.isEmpty()) {
            return Lists.list();
        }
        List rslt = Lists.list();
        for (Edge edge : edges) {
            if (edge.getGuards().isEmpty()) {
                return null;
            }
            Expression guard = CifValueUtils.createConjunction((List)EMFHelper.deepclone((List)edge.getGuards()));
            guard = CifValueUtils.makeInverse((Expression)guard);
            rslt.add(guard);
        }
        return rslt;
    }
}

