/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.java;

import java.util.List;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Lists;

public class JavaClass
extends JavaFile {
    private boolean isAbstract;
    private final String baseclassName;
    private List<String> interfaceNames;
    private List<String> variables;

    public JavaClass(String packageName, boolean isAbstract, String name, String baseclassName, List<String> interfaceNames) {
        super(packageName, name);
        if (interfaceNames == null) {
            interfaceNames = Lists.list();
        }
        this.isAbstract = isAbstract;
        this.baseclassName = baseclassName;
        this.interfaceNames = interfaceNames;
        this.variables = Lists.list();
    }

    public void addVariable(String var) {
        this.variables.add(var);
    }

    public Box toBox() {
        VBox box = new VBox(0);
        this.boxifyPreamble(box);
        Object clsHeader = "public ";
        if (this.isAbstract) {
            clsHeader = (String)clsHeader + "abstract ";
        }
        clsHeader = (String)clsHeader + "class " + this.getClassName();
        if (this.baseclassName != null) {
            clsHeader = (String)clsHeader + " extends " + this.baseclassName;
        }
        if (this.interfaceNames != null && !this.interfaceNames.isEmpty()) {
            Object s = "";
            for (String iName : this.interfaceNames) {
                if (!((String)s).isEmpty()) {
                    s = (String)s + ", ";
                }
                s = (String)s + iName;
            }
            clsHeader = (String)clsHeader + " implements " + (String)s;
        }
        box.add((String)clsHeader + " {");
        VBox body = new VBox(4);
        this.boxifyStandardVariables(body);
        if (!this.variables.isEmpty()) {
            for (String var : this.variables) {
                body.add(var);
            }
        }
        this.boxifyMethods(body);
        box.add((Box)body);
        box.add("}");
        return box;
    }
}

