/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ByteBufferHolder;
import org.apache.coyote.Constants;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HeadersTooLargeException;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractOutputBuffer<S>
implements OutputBuffer {
    protected Response response;
    protected boolean committed;
    protected boolean finished;
    protected byte[] headerBuffer;
    protected int pos;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected OutputBuffer outputStreamOutputBuffer;
    protected long byteCount = 0L;
    protected int socketBuffer = -1;
    protected final LinkedBlockingDeque<ByteBufferHolder> bufferedWrites = new LinkedBlockingDeque();
    protected int bufferedWriteSize = 65536;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    private static final Log log = LogFactory.getLog(AbstractOutputBuffer.class);

    protected AbstractOutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.headerBuffer = new byte[headerBufferSize];
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        HttpMessages.getInstance(response.getLocale()).getMessage(200);
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setBufferedWriteSize(int bufferedWriteSize) {
        this.bufferedWriteSize = bufferedWriteSize;
    }

    public int getBufferedWriteSize() {
        return this.bufferedWriteSize;
    }

    @Override
    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(chunk, res);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk, res);
    }

    @Override
    public long getBytesWritten() {
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.getBytesWritten();
        }
        return this.activeFilters[this.lastActiveFilter].getBytesWritten();
    }

    public void flush() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.COMMIT, null);
        }
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            if (!(this.activeFilters[i] instanceof GzipOutputFilter)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Flushing the gzip filter at position " + i + " of the filter chain..."));
            }
            ((GzipOutputFilter)this.activeFilters[i]).flush();
            break;
        }
        this.flushBuffer(this.isBlocking());
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException(sm.getString("iob.illegalreset"));
        }
        this.pos = 0;
        this.byteCount = 0L;
    }

    public void recycle() {
        this.nextRequest();
        this.bufferedWrites.clear();
    }

    public void nextRequest() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.response.recycle();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        this.byteCount = 0L;
    }

    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.flushBuffer(true);
        this.finished = true;
    }

    public abstract void init(SocketWrapper<S> var1, AbstractEndpoint<S> var2) throws IOException;

    public abstract void sendAck() throws IOException;

    protected abstract void commit() throws IOException;

    public void sendStatus() {
        this.write(org.apache.coyote.http11.Constants.HTTP_11_BYTES);
        this.headerBuffer[this.pos++] = 32;
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write(org.apache.coyote.http11.Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(org.apache.coyote.http11.Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(org.apache.coyote.http11.Constants._404_BYTES);
                break;
            }
            default: {
                this.write(status);
            }
        }
        this.headerBuffer[this.pos++] = 32;
        String message = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
            message = this.response.getMessage();
        }
        if (message == null) {
            this.write(HttpMessages.getInstance(this.response.getLocale()).getMessage(status));
        } else {
            this.write(message);
        }
        if (Constants.IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    AbstractOutputBuffer.this.headerBuffer[AbstractOutputBuffer.this.pos++] = 13;
                    AbstractOutputBuffer.this.headerBuffer[AbstractOutputBuffer.this.pos++] = 10;
                    return null;
                }
            });
        } else {
            this.headerBuffer[this.pos++] = 13;
            this.headerBuffer[this.pos++] = 10;
        }
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        this.write(name);
        this.headerBuffer[this.pos++] = 58;
        this.headerBuffer[this.pos++] = 32;
        this.write(value);
        this.headerBuffer[this.pos++] = 13;
        this.headerBuffer[this.pos++] = 10;
    }

    public void endHeaders() {
        this.headerBuffer[this.pos++] = 13;
        this.headerBuffer[this.pos++] = 10;
    }

    protected void write(MessageBytes mb) {
        if (mb.getType() != 2) {
            mb.toBytes();
            ByteChunk bc = mb.getByteChunk();
            byte[] buffer = bc.getBuffer();
            for (int i = bc.getOffset(); i < bc.getLength(); ++i) {
                if ((buffer[i] <= -1 || buffer[i] > 31 || buffer[i] == 9) && buffer[i] != 127) continue;
                buffer[i] = 32;
            }
        }
        this.write(mb.getByteChunk());
    }

    protected void write(ByteChunk bc) {
        int length = bc.getLength();
        this.checkLengthBeforeWrite(length);
        System.arraycopy(bc.getBytes(), bc.getStart(), this.headerBuffer, this.pos, length);
        this.pos += length;
    }

    public void write(byte[] b) {
        this.checkLengthBeforeWrite(b.length);
        System.arraycopy(b, 0, this.headerBuffer, this.pos, b.length);
        this.pos += b.length;
    }

    protected void write(String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        this.checkLengthBeforeWrite(len);
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            this.headerBuffer[this.pos++] = (byte)c;
        }
    }

    protected void write(int i) {
        this.write(String.valueOf(i));
    }

    private void checkLengthBeforeWrite(int length) {
        if (this.pos + length > this.headerBuffer.length) {
            throw new HeadersTooLargeException(sm.getString("iob.responseheadertoolarge.error"));
        }
    }

    protected abstract boolean hasMoreDataToFlush();

    protected abstract void registerWriteInterest() throws IOException;

    protected abstract boolean flushBuffer(boolean var1) throws IOException;

    protected final boolean isBlocking() {
        return this.response.getWriteListener() == null;
    }

    protected final boolean isReady() throws IOException {
        boolean result;
        boolean bl = result = !this.hasDataToWrite();
        if (!result) {
            this.registerWriteInterest();
        }
        return result;
    }

    public boolean hasDataToWrite() {
        return this.hasMoreDataToFlush() || this.hasBufferedData();
    }

    protected boolean hasBufferedData() {
        boolean result = false;
        if (this.bufferedWrites != null) {
            Iterator<ByteBufferHolder> iter = this.bufferedWrites.iterator();
            while (!result && iter.hasNext()) {
                result = iter.next().hasData();
            }
        }
        return result;
    }
}

