/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.jni.Status;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class AprServletOutputStream
extends AbstractServletOutputStream<Long> {
    private static final int SSL_OUTPUT_BUFFER_SIZE = 8192;
    private final AprEndpoint endpoint;
    private final long socket;
    private volatile boolean closed = false;
    private final ByteBuffer sslOutputBuffer;

    public AprServletOutputStream(SocketWrapper<Long> socketWrapper, int asyncWriteBufferSize, AprEndpoint endpoint) {
        super(socketWrapper, asyncWriteBufferSize);
        this.endpoint = endpoint;
        this.socket = socketWrapper.getSocket();
        if (endpoint.isSSLEnabled()) {
            this.sslOutputBuffer = ByteBuffer.allocateDirect(8192);
            this.sslOutputBuffer.position(8192);
        } else {
            this.sslOutputBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWrite(boolean block, byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("apr.closed", new Object[]{this.socket}));
        }
        Lock readLock = this.socketWrapper.getBlockingStatusReadLock();
        ReentrantReadWriteLock.WriteLock writeLock = this.socketWrapper.getBlockingStatusWriteLock();
        readLock.lock();
        try {
            if (this.socketWrapper.getBlockingStatus() == block) {
                int n = this.doWriteInternal(b, off, len);
                return n;
            }
        }
        finally {
            readLock.unlock();
        }
        writeLock.lock();
        try {
            this.socketWrapper.setBlockingStatus(block);
            if (block) {
                Socket.timeoutSet((long)this.socket, (long)(this.endpoint.getSoTimeout() * 1000));
            } else {
                Socket.timeoutSet((long)this.socket, (long)0L);
            }
            readLock.lock();
            try {
                writeLock.unlock();
                int n = this.doWriteInternal(b, off, len);
                readLock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                readLock.unlock();
                throw throwable;
            }
        }
        finally {
            if (writeLock.isHeldByCurrentThread()) {
                writeLock.unlock();
            }
        }
    }

    private int doWriteInternal(byte[] b, int off, int len) throws IOException {
        int written;
        int start = off;
        int left = len;
        do {
            if (this.endpoint.isSSLEnabled()) {
                if (this.sslOutputBuffer.remaining() == 0) {
                    this.sslOutputBuffer.clear();
                    if (left < 8192) {
                        this.sslOutputBuffer.put(b, start, left);
                    } else {
                        this.sslOutputBuffer.put(b, start, 8192);
                    }
                    this.sslOutputBuffer.flip();
                }
                if ((written = Socket.sendb((long)this.socket, (ByteBuffer)this.sslOutputBuffer, (int)this.sslOutputBuffer.position(), (int)this.sslOutputBuffer.limit())) > 0) {
                    this.sslOutputBuffer.position(this.sslOutputBuffer.position() + written);
                }
            } else {
                written = Socket.send((long)this.socket, (byte[])b, (int)start, (int)left);
            }
            if (Status.APR_STATUS_IS_EAGAIN((int)(-written))) {
                written = 0;
            } else {
                if (-written == 70014) {
                    throw new EOFException(sm.getString("apr.clientAbort"));
                }
                if ((OS.IS_WIN32 || OS.IS_WIN64) && -written == 730053) {
                    throw new EOFException(sm.getString("apr.clientAbort"));
                }
                if (written < 0) {
                    throw new IOException(sm.getString("apr.write.error", new Object[]{-written, this.socket, this.socketWrapper}));
                }
            }
            start += written;
        } while (written > 0 && (left -= written) > 0);
        if (left > 0) {
            this.endpoint.getPoller().add(this.socket, -1, false, true);
        }
        return len - left;
    }

    @Override
    protected void doFlush() throws IOException {
    }

    @Override
    protected void doClose() throws IOException {
        this.closed = true;
    }
}

