/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.gemini.web.core.WebContainerProperties;
import org.eclipse.gemini.web.core.spi.ServletContainer;
import org.eclipse.gemini.web.tomcat.internal.TomcatConfigLocator;
import org.eclipse.gemini.web.tomcat.internal.TomcatServletContainer;
import org.eclipse.gemini.web.tomcat.internal.TomcatServletContainerFactory;
import org.eclipse.gemini.web.tomcat.internal.TomcatWebContainerProperties;
import org.eclipse.gemini.web.tomcat.internal.loading.DirContextURLStreamHandlerService;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.url.URLStreamHandlerService;

public class Activator
implements BundleActivator {
    private final Object monitor = new Object();
    private final ServiceRegistrationTracker tracker = new ServiceRegistrationTracker();
    private TomcatServletContainer container;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        this.registerURLStreamHandler(context);
        this.registerConnectorDescriptors(context);
        TomcatServletContainer container = this.createContainer(context);
        container.start();
        ServiceRegistration sr = context.registerService(ServletContainer.class.getName(), (Object)container, null);
        this.tracker.track(sr);
        Object object = this.monitor;
        synchronized (object) {
            this.container = container;
        }
    }

    private void registerConnectorDescriptors(BundleContext context) {
        TomcatWebContainerProperties tomcatWebContainerProperties = new TomcatWebContainerProperties();
        ServiceRegistration registration = context.registerService(WebContainerProperties.class.getName(), (Object)tomcatWebContainerProperties, null);
        this.tracker.track(registration);
    }

    private void registerURLStreamHandler(BundleContext context) {
        Properties properties = new Properties();
        properties.put("url.handler.protocol", "jndi");
        DirContextURLStreamHandlerService handler = new DirContextURLStreamHandlerService();
        ServiceRegistration reg = context.registerService(URLStreamHandlerService.class.getName(), (Object)handler, (Dictionary)properties);
        this.tracker.track(reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        TomcatServletContainer container;
        Object object = this.monitor;
        synchronized (object) {
            container = this.container;
            this.container = null;
        }
        if (container != null) {
            container.stop();
        }
        this.tracker.unregisterAll();
    }

    private TomcatServletContainer createContainer(BundleContext context) throws BundleException {
        TomcatServletContainerFactory factory = new TomcatServletContainerFactory();
        InputStream configFile = this.resolveConfigFile(context);
        try {
            TomcatServletContainer tomcatServletContainer = factory.createContainer(configFile, context, this.getPackageAdmin(context));
            return tomcatServletContainer;
        }
        finally {
            IOUtils.closeQuietly((Closeable)configFile);
        }
    }

    private InputStream resolveConfigFile(BundleContext context) throws BundleException {
        return TomcatConfigLocator.resolveConfigFile(context);
    }

    private PackageAdmin getPackageAdmin(BundleContext bundleContext) {
        PackageAdmin packageAdmin;
        ServiceReference serviceReference = bundleContext.getServiceReference(PackageAdmin.class.getName());
        if (serviceReference != null && (packageAdmin = (PackageAdmin)bundleContext.getService(serviceReference)) != null) {
            return packageAdmin;
        }
        throw new IllegalStateException("PackageAdmin not available in the service registry");
    }
}

