/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class DedicatedThreadExecutor {
    private final SingleThreadFactory singleThreadFactory = new SingleThreadFactory();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(this.singleThreadFactory);

    public <V> V execute(Callable<V> callable) {
        V result;
        Future<V> futureTask = this.executorService.submit(callable);
        boolean interrupted = false;
        while (true) {
            try {
                result = futureTask.get();
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    public void shutdown() {
        this.executorService.shutdown();
        if (this.singleThreadFactory.singleThread != null) {
            boolean interrupted = false;
            while (true) {
                try {
                    this.singleThreadFactory.singleThread.join();
                    this.singleThreadFactory.singleThread = null;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V executeInOwnThread(Callable<V> callable) {
        DedicatedThreadExecutor executor = new DedicatedThreadExecutor();
        try {
            V v = executor.execute(callable);
            return v;
        }
        finally {
            executor.shutdown();
        }
    }

    private static class SingleThreadFactory
    implements ThreadFactory {
        private volatile Thread singleThread;

        private SingleThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            if (this.singleThread != null) {
                throw new IllegalStateException("should not have been called more than once");
            }
            this.singleThread = new Thread(r);
            this.singleThread.setDaemon(true);
            return this.singleThread;
        }
    }
}

