/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.MD5Encoder;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class DigestAuthenticator
extends AuthenticatorBase {
    private static final Log log = LogFactory.getLog(DigestAuthenticator.class);
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static final String info = "org.apache.catalina.authenticator.DigestAuthenticator/1.0";
    protected static final String QOP = "auth";
    protected static volatile MessageDigest md5Helper;
    protected Map<String, NonceInfo> cnonces;
    protected int cnonceCacheSize = 1000;
    protected String key = null;
    protected long nonceValidity = 300000L;
    protected String opaque;
    protected boolean validateUri = true;

    public DigestAuthenticator() {
        try {
            if (md5Helper == null) {
                md5Helper = MessageDigest.getInstance("MD5");
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    public int getCnonceCacheSize() {
        return this.cnonceCacheSize;
    }

    public void setCnonceCacheSize(int cnonceCacheSize) {
        this.cnonceCacheSize = cnonceCacheSize;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getNonceValidity() {
        return this.nonceValidity;
    }

    public void setNonceValidity(long nonceValidity) {
        this.nonceValidity = nonceValidity;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public boolean isValidateUri() {
        return this.validateUri;
    }

    public void setValidateUri(boolean validateUri) {
        this.validateUri = validateUri;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            String ssoId;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            if ((ssoId = (String)request.getNote("org.apache.catalina.request.SSOID")) != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        String authorization = request.getHeader("authorization");
        DigestInfo digestInfo = new DigestInfo(this.getOpaque(), this.getNonceValidity(), this.getKey(), this.cnonces, this.isValidateUri());
        if (authorization != null) {
            if (digestInfo.validate(request, authorization, config)) {
                principal = digestInfo.authenticate(this.context.getRealm());
            }
            if (principal != null) {
                String username = this.parseUsername(authorization);
                this.register(request, response, principal, "DIGEST", username, null);
                return true;
            }
        }
        String nonce = this.generateNonce(request);
        this.setAuthenticateHeader(request, response, config, nonce, digestInfo.isNonceStale());
        response.sendError(401);
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "DIGEST";
    }

    protected String parseUsername(String authorization) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Digest ")) {
            return null;
        }
        authorization = authorization.substring(7).trim();
        StringTokenizer commaTokenizer = new StringTokenizer(authorization, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String currentToken = commaTokenizer.nextToken();
            int equalSign = currentToken.indexOf(61);
            if (equalSign < 0) {
                return null;
            }
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1).trim();
            if (!"username".equals(currentTokenName)) continue;
            return DigestAuthenticator.removeQuotes(currentTokenValue);
        }
        return null;
    }

    protected static String removeQuotes(String quotedString, boolean quotesRequired) {
        if (quotedString.length() > 0 && quotedString.charAt(0) != '\"' && !quotesRequired) {
            return quotedString;
        }
        if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return "";
    }

    protected static String removeQuotes(String quotedString) {
        return DigestAuthenticator.removeQuotes(quotedString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateNonce(Request request) {
        byte[] buffer;
        long currentTime = System.currentTimeMillis();
        String ipTimeKey = request.getRemoteAddr() + ":" + currentTime + ":" + this.getKey();
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            buffer = md5Helper.digest(ipTimeKey.getBytes());
        }
        return currentTime + ":" + md5Encoder.encode(buffer);
    }

    protected void setAuthenticateHeader(HttpServletRequest request, HttpServletResponse response, LoginConfig config, String nOnce, boolean isNonceStale) {
        String realmName = config.getRealmName();
        if (realmName == null) {
            realmName = "Authentication required";
        }
        String authenticateHeader = isNonceStale ? "Digest realm=\"" + realmName + "\", " + "qop=\"" + QOP + "\", nonce=\"" + nOnce + "\", " + "opaque=\"" + this.getOpaque() + "\", stale=true" : "Digest realm=\"" + realmName + "\", " + "qop=\"" + QOP + "\", nonce=\"" + nOnce + "\", " + "opaque=\"" + this.getOpaque() + "\"";
        response.setHeader("WWW-Authenticate", authenticateHeader);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.getKey() == null) {
            this.setKey(this.sessionIdGenerator.generateSessionId());
        }
        if (this.getOpaque() == null) {
            this.setOpaque(this.sessionIdGenerator.generateSessionId());
        }
        this.cnonces = new LinkedHashMap<String, NonceInfo>(){
            private static final long serialVersionUID = 1L;
            private static final long LOG_SUPPRESS_TIME = 300000L;
            private long lastLog = 0L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, NonceInfo> eldest) {
                long currentTime = System.currentTimeMillis();
                if (this.size() > DigestAuthenticator.this.getCnonceCacheSize()) {
                    if (this.lastLog < currentTime && currentTime - eldest.getValue().getTimestamp() < DigestAuthenticator.this.getNonceValidity()) {
                        log.warn((Object)AuthenticatorBase.sm.getString("digestAuthenticator.cacheRemove"));
                        this.lastLog = currentTime + 300000L;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private static class NonceInfo {
        private volatile long count;
        private volatile long timestamp;

        private NonceInfo() {
        }

        public void setCount(long l) {
            this.count = l;
        }

        public long getCount() {
            return this.count;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private static class DigestInfo {
        private String opaque;
        private long nonceValidity;
        private String key;
        private Map<String, NonceInfo> cnonces;
        private boolean validateUri = true;
        private String userName = null;
        private String method = null;
        private String uri = null;
        private String response = null;
        private String nonce = null;
        private String nc = null;
        private String cnonce = null;
        private String realmName = null;
        private String qop = null;
        private boolean nonceStale = false;

        public DigestInfo(String opaque, long nonceValidity, String key, Map<String, NonceInfo> cnonces, boolean validateUri) {
            this.opaque = opaque;
            this.nonceValidity = nonceValidity;
            this.key = key;
            this.cnonces = cnonces;
            this.validateUri = validateUri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validate(Request request, String authorization, LoginConfig config) {
            long nOnceTime;
            String query;
            String uriQuery;
            if (authorization == null) {
                return false;
            }
            if (!authorization.startsWith("Digest ")) {
                return false;
            }
            authorization = authorization.substring(7).trim();
            String[] tokens = authorization.split(",(?=(?:[^\"]*\"[^\"]*\")+$)");
            this.method = request.getMethod();
            String opaque = null;
            for (int i = 0; i < tokens.length; ++i) {
                String currentToken = tokens[i];
                if (currentToken.length() == 0) continue;
                int equalSign = currentToken.indexOf(61);
                if (equalSign < 0) {
                    return false;
                }
                String currentTokenName = currentToken.substring(0, equalSign).trim();
                String currentTokenValue = currentToken.substring(equalSign + 1).trim();
                if ("username".equals(currentTokenName)) {
                    this.userName = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("realm".equals(currentTokenName)) {
                    this.realmName = DigestAuthenticator.removeQuotes(currentTokenValue, true);
                }
                if ("nonce".equals(currentTokenName)) {
                    this.nonce = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("nc".equals(currentTokenName)) {
                    this.nc = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("cnonce".equals(currentTokenName)) {
                    this.cnonce = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("qop".equals(currentTokenName)) {
                    this.qop = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("uri".equals(currentTokenName)) {
                    this.uri = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if ("response".equals(currentTokenName)) {
                    this.response = DigestAuthenticator.removeQuotes(currentTokenValue);
                }
                if (!"opaque".equals(currentTokenName)) continue;
                opaque = DigestAuthenticator.removeQuotes(currentTokenValue);
            }
            if (this.userName == null || this.realmName == null || this.nonce == null || this.uri == null || this.response == null) {
                return false;
            }
            if (this.validateUri && !this.uri.equals(uriQuery = (query = request.getQueryString()) == null ? request.getRequestURI() : request.getRequestURI() + "?" + query)) {
                return false;
            }
            String lcRealm = config.getRealmName();
            if (lcRealm == null) {
                lcRealm = "Authentication required";
            }
            if (!lcRealm.equals(this.realmName)) {
                return false;
            }
            if (!this.opaque.equals(opaque)) {
                return false;
            }
            int i = this.nonce.indexOf(":");
            if (i < 0 || i + 1 == this.nonce.length()) {
                return false;
            }
            try {
                nOnceTime = Long.parseLong(this.nonce.substring(0, i));
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            String md5clientIpTimeKey = this.nonce.substring(i + 1);
            long currentTime = System.currentTimeMillis();
            if (currentTime - nOnceTime > this.nonceValidity) {
                this.nonceStale = true;
                return false;
            }
            String serverIpTimeKey = request.getRemoteAddr() + ":" + nOnceTime + ":" + this.key;
            byte[] buffer = null;
            MessageDigest messageDigest = md5Helper;
            synchronized (messageDigest) {
                buffer = md5Helper.digest(serverIpTimeKey.getBytes());
            }
            String md5ServerIpTimeKey = md5Encoder.encode(buffer);
            if (!md5ServerIpTimeKey.equals(md5clientIpTimeKey)) {
                return false;
            }
            if (this.qop != null && !DigestAuthenticator.QOP.equals(this.qop)) {
                return false;
            }
            if (this.qop == null) {
                if (this.cnonce != null || this.nc != null) {
                    return false;
                }
            } else {
                NonceInfo info;
                long count;
                if (this.cnonce == null || this.nc == null) {
                    return false;
                }
                if (this.nc.length() != 8) {
                    return false;
                }
                try {
                    count = Long.parseLong(this.nc, 16);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                Map<String, NonceInfo> map = this.cnonces;
                synchronized (map) {
                    info = this.cnonces.get(this.cnonce);
                }
                if (info == null) {
                    info = new NonceInfo();
                } else if (count <= info.getCount()) {
                    return false;
                }
                info.setCount(count);
                info.setTimestamp(currentTime);
                map = this.cnonces;
                synchronized (map) {
                    this.cnonces.put(this.cnonce, info);
                }
            }
            return true;
        }

        public boolean isNonceStale() {
            return this.nonceStale;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Principal authenticate(Realm realm) {
            byte[] buffer;
            String a2 = this.method + ":" + this.uri;
            MessageDigest messageDigest = md5Helper;
            synchronized (messageDigest) {
                buffer = md5Helper.digest(a2.getBytes());
            }
            String md5a2 = md5Encoder.encode(buffer);
            return realm.authenticate(this.userName, this.response, this.nonce, this.nc, this.cnonce, this.qop, this.realmName, md5a2);
        }
    }
}

