/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi;

import org.osgi.framework.Version;

public final class VersionRange {
    private static final Version ZERO_VERSION = Version.emptyVersion;
    private static final char INCLUSIVE_LOWER = '[';
    private static final char INCLUSIVE_UPPER = ']';
    private static final char EXCLUSIVE_LOWER = '(';
    private static final char EXCLUSIVE_UPPER = ')';
    public static final VersionRange NATURAL_NUMBER_RANGE = new VersionRange(null);
    private final Version floor;
    private final Version ceiling;
    private final boolean floorInclusive;
    private final boolean ceilingInclusive;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VersionRange(String versionRange) {
        if (versionRange == null || versionRange.length() == 0) {
            this.floor = ZERO_VERSION;
            this.ceiling = null;
            this.floorInclusive = true;
            this.ceilingInclusive = false;
            return;
        }
        char first = versionRange.charAt(0);
        if (first == '[' || first == '(') {
            char last = versionRange.charAt(versionRange.length() - 1);
            if (last != ']' && last != ')') throw new IllegalArgumentException("Version range '" + versionRange + "' is invalid.");
            int comma = versionRange.indexOf(44);
            if (comma < 0) {
                throw new IllegalArgumentException("Version range '" + versionRange + "' is invalid.");
            }
            this.floor = Version.parseVersion((String)versionRange.substring(1, comma).trim());
            this.floorInclusive = first == '[';
            this.ceiling = Version.parseVersion((String)versionRange.substring(comma + 1, versionRange.length() - 1).trim());
            this.ceilingInclusive = last == ']';
            return;
        } else {
            this.floor = Version.parseVersion((String)versionRange);
            this.floorInclusive = true;
            this.ceiling = null;
            this.ceilingInclusive = false;
        }
    }

    private VersionRange(boolean floorInclusive, Version floor, Version ceiling, boolean ceilingInclusive) {
        this.floorInclusive = floorInclusive;
        this.floor = floor;
        this.ceiling = ceiling;
        this.ceilingInclusive = ceilingInclusive;
    }

    public static VersionRange naturalNumberRange() {
        return NATURAL_NUMBER_RANGE;
    }

    public static VersionRange createExactRange(Version version) {
        return new VersionRange(true, version, version, true);
    }

    public Version getFloor() {
        return this.floor;
    }

    public Version getCeiling() {
        return this.ceiling;
    }

    public boolean isFloorInclusive() {
        return this.floorInclusive;
    }

    public boolean isCeilingInclusive() {
        return this.ceilingInclusive;
    }

    public boolean includes(Version version) {
        int maxCheck;
        int minCheck = this.floorInclusive ? 0 : 1;
        int n = maxCheck = this.ceilingInclusive ? 0 : -1;
        if (this.floor == null) {
            throw new RuntimeException("ff");
        }
        return version.compareTo(this.floor) >= minCheck && (this.ceiling == null || version.compareTo(this.ceiling) <= maxCheck);
    }

    public boolean isExact() {
        return this.isCeilingInclusive() && this.isFloorInclusive() && this.getFloor().equals((Object)this.getCeiling());
    }

    public boolean equals(Object object) {
        if (!(object instanceof VersionRange)) {
            return false;
        }
        VersionRange that = (VersionRange)object;
        return this.isEmpty() && that.isEmpty() || this.floorInclusive == that.floorInclusive && this.ceilingInclusive == that.ceilingInclusive && this.floor.equals((Object)that.floor) && (this.ceiling == null && that.ceiling == null || this.ceiling != null && this.ceiling.equals((Object)that.ceiling));
    }

    public boolean isEmpty() {
        if (this.ceiling == null) {
            return false;
        }
        int limitComparison = this.ceiling.compareTo(this.floor);
        if (limitComparison == 0) {
            return !this.floorInclusive || !this.ceilingInclusive;
        }
        return limitComparison < 0;
    }

    public int hashCode() {
        int result = 17;
        if (!this.isEmpty()) {
            result = 37 * result + this.floor.hashCode();
            result = 37 * result + (this.ceiling == null ? 0 : this.ceiling.hashCode());
        }
        return result;
    }

    public String toString() {
        return "" + (this.floorInclusive ? (char)'[' : '(') + this.floor + ", " + (this.ceiling == null ? "oo" : this.ceiling) + (this.ceilingInclusive ? (char)']' : ')');
    }

    public String toParseString() {
        if (this.ceiling == null && this.floorInclusive) {
            return this.floor.toString();
        }
        return "" + (this.floorInclusive ? (char)'[' : '(') + this.floor + ", " + this.ceiling + (this.ceilingInclusive ? (char)']' : ')');
    }

    public static VersionRange intersection(VersionRange rangeOne, VersionRange rangeTwo) {
        boolean ceilingInclusive;
        Version ceiling;
        boolean floorInclusive;
        Version floor;
        int floorComparison = rangeOne.floor.compareTo(rangeTwo.floor);
        if (floorComparison < 0) {
            floor = rangeTwo.floor;
            floorInclusive = rangeTwo.floorInclusive;
        } else if (floorComparison > 0) {
            floor = rangeOne.floor;
            floorInclusive = rangeOne.floorInclusive;
        } else {
            floor = rangeOne.floor;
            boolean bl = floorInclusive = rangeOne.floorInclusive && rangeTwo.floorInclusive;
        }
        if (rangeOne.ceiling == null) {
            if (rangeTwo.ceiling == null) {
                ceiling = null;
                ceilingInclusive = false;
            } else {
                ceiling = rangeTwo.ceiling;
                ceilingInclusive = rangeTwo.ceilingInclusive;
            }
        } else if (rangeTwo.ceiling == null) {
            ceiling = rangeOne.ceiling;
            ceilingInclusive = rangeOne.ceilingInclusive;
        } else {
            int ceilingComparison = rangeOne.ceiling.compareTo(rangeTwo.ceiling);
            if (ceilingComparison > 0) {
                ceiling = rangeTwo.ceiling;
                ceilingInclusive = rangeTwo.ceilingInclusive;
            } else if (ceilingComparison < 0) {
                ceiling = rangeOne.ceiling;
                ceilingInclusive = rangeOne.ceilingInclusive;
            } else {
                ceiling = rangeOne.ceiling;
                ceilingInclusive = rangeOne.ceilingInclusive && rangeTwo.ceilingInclusive;
            }
        }
        return new VersionRange(floorInclusive, floor, ceiling, ceilingInclusive);
    }
}

