/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.tomcat.util.http.RequestUtil;

public class FileDirContext
extends BaseDirContext {
    private static final Log log = LogFactory.getLog(FileDirContext.class);
    protected static final int BUFFER_SIZE = 2048;
    protected File base = null;
    protected String absoluteBase = null;
    protected boolean allowLinking = false;

    public FileDirContext() {
    }

    public FileDirContext(Hashtable<String, Object> env) {
        super(env);
    }

    @Override
    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(sm.getString("resources.null"));
        }
        this.base = new File(docBase);
        try {
            this.base = this.base.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(this.base.exists() && this.base.isDirectory() && this.base.canRead())) {
            throw new IllegalArgumentException(sm.getString("fileResources.base", docBase));
        }
        this.absoluteBase = this.base.getAbsolutePath();
        super.setDocBase(docBase);
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    protected String doGetRealPath(String path) {
        File file = new File(this.getDocBase(), path);
        return file.getAbsolutePath();
    }

    @Override
    protected Object doLookup(String name) {
        Object result = null;
        File file = this.file(name);
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            FileDirContext tempContext = new FileDirContext(this.env);
            tempContext.setDocBase(file.getPath());
            tempContext.setAllowLinking(this.getAllowLinking());
            result = tempContext;
        } else {
            result = new FileResource(file);
        }
        return result;
    }

    @Override
    public void unbind(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NameNotFoundException(sm.getString("resources.notFound", name));
        }
        if (!file.delete()) {
            throw new NamingException(sm.getString("resources.unbindFailed", name));
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        File file = this.file(oldName);
        if (file == null) {
            throw new NameNotFoundException(sm.getString("resources.notFound", oldName));
        }
        File newFile = new File(this.base, newName);
        if (!file.renameTo(newFile)) {
            throw new NamingException(sm.getString("resources.renameFail", oldName, newName));
        }
    }

    @Override
    protected List<NamingEntry> doListBindings(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            return null;
        }
        return this.list(file);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.unbind(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    @Override
    protected Attributes doGetAttributes(String name, String[] attrIds) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            return null;
        }
        return new FileResourceAttributes(file);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(sm.getString("resources.alreadyBound", name));
        }
        this.rebind(name, obj, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        InputStream is = null;
        if (obj instanceof Resource) {
            try {
                is = ((Resource)obj).streamContent();
            }
            catch (IOException e) {}
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        } else if (obj instanceof DirContext) {
            if (file.exists() && !file.delete()) {
                throw new NamingException(sm.getString("resources.bindFailed", name));
            }
            if (!file.mkdir()) {
                throw new NamingException(sm.getString("resources.bindFailed", name));
            }
        }
        if (is == null) {
            throw new NamingException(sm.getString("resources.bindFailed", name));
        }
        try {
            FileOutputStream os = null;
            byte[] buffer = new byte[2048];
            int len = -1;
            try {
                os = new FileOutputStream(file);
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
                is.close();
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException(sm.getString("resources.bindFailed", e));
            ne.initCause(e);
            throw ne;
        }
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(sm.getString("resources.alreadyBound", name));
        }
        if (!file.mkdir()) {
            throw new NamingException(sm.getString("resources.bindFailed", name));
        }
        return (DirContext)this.lookup(name);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return null;
    }

    protected String normalize(String path) {
        return RequestUtil.normalize((String)path, (File.separatorChar == '\\' ? 1 : 0) != 0);
    }

    protected File file(String name) {
        File file = new File(this.base, name);
        if (file.exists() && file.canRead()) {
            if (this.allowLinking) {
                return file;
            }
            String canPath = null;
            try {
                canPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (canPath == null) {
                return null;
            }
            if (!canPath.startsWith(this.absoluteBase)) {
                return null;
            }
            String fileAbsPath = file.getAbsolutePath();
            if (fileAbsPath.endsWith(".")) {
                fileAbsPath = fileAbsPath + "/";
            }
            String absPath = this.normalize(fileAbsPath);
            canPath = this.normalize(canPath);
            if (this.absoluteBase.length() < absPath.length() && this.absoluteBase.length() < canPath.length()) {
                if ((absPath = absPath.substring(this.absoluteBase.length() + 1)) == null) {
                    return null;
                }
                if (absPath.equals("")) {
                    absPath = "/";
                }
                if ((canPath = canPath.substring(this.absoluteBase.length() + 1)).equals("")) {
                    canPath = "/";
                }
                if (!canPath.equals(absPath)) {
                    return null;
                }
            }
        } else {
            return null;
        }
        return file;
    }

    protected List<NamingEntry> list(File file) {
        ArrayList<NamingEntry> entries = new ArrayList<NamingEntry>();
        if (!file.isDirectory()) {
            return entries;
        }
        Object[] names = file.list();
        if (names == null) {
            log.warn((Object)sm.getString("fileResources.listingNull", file.getAbsolutePath()));
            return entries;
        }
        Arrays.sort(names);
        NamingEntry entry = null;
        for (int i = 0; i < names.length; ++i) {
            File currentFile = new File(file, (String)names[i]);
            Object object = null;
            if (currentFile.isDirectory()) {
                FileDirContext tempContext = new FileDirContext(this.env);
                tempContext.setDocBase(currentFile.getPath());
                tempContext.setAllowLinking(this.getAllowLinking());
                object = tempContext;
            } else {
                object = new FileResource(currentFile);
            }
            entry = new NamingEntry((String)names[i], object, 0);
            entries.add(entry);
        }
        return entries;
    }

    protected static class FileResource
    extends Resource {
        protected File file;

        public FileResource(File file) {
            this.file = file;
        }

        @Override
        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                FileInputStream fis = new FileInputStream(this.file);
                this.inputStream = fis;
                return fis;
            }
            return super.streamContent();
        }
    }

    protected static class FileResourceAttributes
    extends ResourceAttributes {
        private static final long serialVersionUID = 1L;
        protected File file;
        protected boolean accessed = false;
        protected String canonicalPath = null;

        public FileResourceAttributes(File file) {
            this.file = file;
            this.getCreation();
            this.getLastModified();
        }

        @Override
        public boolean isCollection() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.isCollection();
        }

        @Override
        public long getContentLength() {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.file.length();
            return this.contentLength;
        }

        @Override
        public long getCreation() {
            if (this.creation != -1L) {
                return this.creation;
            }
            this.creation = this.getLastModified();
            return this.creation;
        }

        @Override
        public Date getCreationDate() {
            if (this.creation == -1L) {
                this.creation = this.getCreation();
            }
            return super.getCreationDate();
        }

        @Override
        public long getLastModified() {
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            this.lastModified = this.file.lastModified();
            return this.lastModified;
        }

        @Override
        public Date getLastModifiedDate() {
            if (this.lastModified == -1L) {
                this.lastModified = this.getLastModified();
            }
            return super.getLastModifiedDate();
        }

        @Override
        public String getName() {
            if (this.name == null) {
                this.name = this.file.getName();
            }
            return this.name;
        }

        @Override
        public String getResourceType() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.getResourceType();
        }

        @Override
        public String getCanonicalPath() {
            if (this.canonicalPath == null) {
                try {
                    this.canonicalPath = this.file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.canonicalPath;
        }
    }
}

