/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemoc.timeline.model.Choice;
import org.eclipse.gemoc.timeline.model.Connection;
import org.eclipse.gemoc.timeline.model.TimelineWindow;
import org.eclipse.gemoc.timeline.view.ITimelineProvider;

public final class PossibleStep {
    private static final int SHIFT = 8;
    private final TimelineWindow timelineWindow;
    private final int branch;
    private final int index;
    private final int possibleStep;

    public PossibleStep(TimelineWindow timelineWindow, int branch, int index, int possibleStep) {
        this.timelineWindow = timelineWindow;
        this.branch = branch;
        this.index = index;
        this.possibleStep = possibleStep;
    }

    public TimelineWindow getTimelineWindow() {
        return this.timelineWindow;
    }

    public String getName() {
        return this.getTimelineWindow().getProvider().getTextAt(this.branch, this.index, this.possibleStep);
    }

    public boolean isSelected() {
        return this.getTimelineWindow().getProvider().getSelectedPossibleStep(this.branch, this.index) == this.possibleStep;
    }

    public Choice getChoice() {
        return new Choice(this.getTimelineWindow(), this.branch, this.index);
    }

    public PossibleStep getPreviousPossibleStep() {
        PossibleStep res = this.possibleStep > 0 ? new PossibleStep(this.getTimelineWindow(), this.branch, this.index, this.possibleStep - 1) : null;
        return res;
    }

    public PossibleStep getNextPossibleStep() {
        PossibleStep res = this.possibleStep < this.getTimelineWindow().getProvider().getNumberOfPossibleStepsAt(this.branch, this.index) ? new PossibleStep(this.getTimelineWindow(), this.branch, this.index, this.possibleStep + 1) : null;
        return res;
    }

    public int getPossibleStepIndex() {
        return this.possibleStep;
    }

    public int getChoiceIndex() {
        return this.index;
    }

    public List<Connection> getPreceding() {
        ArrayList<Connection> res = new ArrayList<Connection>();
        ITimelineProvider provider = this.getTimelineWindow().getProvider();
        if (this.isSelected() && this.index > this.getTimelineWindow().getStart()) {
            int[][] precedings = provider.getPrecedings(this.branch, this.index, this.possibleStep);
            int i = 0;
            while (i < precedings.length) {
                int precedingBranch = precedings[i][0];
                int preceding = precedings[i][1];
                if (preceding >= 0) {
                    res.add(new Connection(new PossibleStep(this.getTimelineWindow(), precedingBranch, this.index - 1, preceding), this));
                }
                ++i;
            }
        }
        return res;
    }

    public List<Connection> getFollowing() {
        ArrayList<Connection> res = new ArrayList<Connection>();
        ITimelineProvider provider = this.getTimelineWindow().getProvider();
        if (this.isSelected() && this.index + 1 < Math.min(this.getTimelineWindow().getEnd(), this.getTimelineWindow().getMaxTimelineIndex())) {
            int[][] followings = provider.getFollowings(this.branch, this.index, this.possibleStep);
            int i = 0;
            while (i < followings.length) {
                int followingBranch = followings[i][0];
                int following = followings[i][1];
                if (following >= 0) {
                    res.add(new Connection(this, new PossibleStep(this.getTimelineWindow(), followingBranch, this.index + 1, following)));
                }
                ++i;
            }
        }
        return res;
    }

    public int hashCode() {
        return ((this.branch << 4) + this.index << 8) + this.possibleStep;
    }

    public boolean equals(Object obj) {
        return obj instanceof PossibleStep && ((PossibleStep)obj).branch == this.branch && ((PossibleStep)obj).index == this.index && ((PossibleStep)obj).possibleStep == this.possibleStep;
    }

    public Object getPossibleStep() {
        return this.getTimelineWindow().getProvider().getAt(this.branch, this.index, this.possibleStep);
    }

    public Object getChoice2() {
        return this.getTimelineWindow().getProvider().getAt(this.branch, this.index);
    }

    public boolean isCurrent() {
        ITimelineProvider provider = this.getTimelineWindow().getProvider();
        return this.branch == provider.getCurrentBranch() && this.index == provider.getCurrentChoice() && this.possibleStep == provider.getCurrentPossibleStep();
    }
}

