/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaengine.ui.launcher;

import java.util.Formatter;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.commons.eclipse.emf.EObjectUtil;
import org.eclipse.gemoc.dsl.debug.DebugTarget;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.Thread;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLDebugTargetAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLThreadAdapter;
import org.eclipse.gemoc.execution.sequential.javaengine.ui.Activator;
import org.eclipse.gemoc.execution.sequential.javaengine.ui.launcher.GemocDebugModelPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class PlainK3DebugModelPresentation
extends GemocDebugModelPresentation
implements IFontProvider {
    private Image image;

    public String getText(Object element) {
        if (element instanceof Adapter) {
            Notifier target = ((Adapter)element).getTarget();
            if (target instanceof DebugTarget) {
                return ((DebugTarget)target).getName();
            }
            if (target instanceof Thread) {
                return ((Thread)target).getName();
            }
            if (target instanceof StackFrame) {
                StackFrame t = (StackFrame)target;
                if (t.getCurrentInstruction() != t.getContext()) {
                    DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();
                    StringBuilder sb = new StringBuilder();
                    Formatter formatter = new Formatter(sb);
                    QualifiedName qn = nameprovider.getFullyQualifiedName(t.getCurrentInstruction());
                    if (qn != null) {
                        formatter.format("%s => %s", t.getName(), qn);
                    } else {
                        String resBasedName = EObjectUtil.getResourceBasedName((EObject)t.getCurrentInstruction(), (boolean)false);
                        if (resBasedName != null) {
                            formatter.format("%s  => %s", t.getName(), resBasedName);
                        } else {
                            formatter.format("%s  => %s", t.getName(), t.getCurrentInstruction());
                        }
                    }
                    formatter.close();
                    return sb.toString();
                }
                return ((StackFrame)target).getName();
            }
        }
        return super.getText(element);
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof DSLDebugTargetAdapter || element instanceof DSLThreadAdapter) {
            ImageDescriptor descriptor = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.execution.sequential.javaengine.ui", (String)"icons/debugt_obj.png");
            Image cachedImage = (Image)this.imagesCache.get(descriptor);
            if (cachedImage == null) {
                cachedImage = new Image((Device)Display.getDefault(), descriptor.getImageData(100));
                this.imagesCache.put(descriptor, cachedImage);
            }
            return this.image;
        }
        return super.getImage(element);
    }

    public Font getFont(Object element) {
        StackFrame t;
        Notifier target;
        if (element instanceof Adapter && (target = ((Adapter)element).getTarget()) instanceof StackFrame && (t = (StackFrame)target).getChildFrame() == null) {
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
        return null;
    }
}

