/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.executionframework.debugger.Activator;
import org.eclipse.gemoc.trace.commons.model.trace.Step;

public class GemocBreakpoint
extends DSLBreakpoint {
    public static final String MARKER_ID = "org.eclipse.gemoc.gemoc_modeling_workbench.ui.breakpoint.breakpointMarker";
    public static final String BREAK_ON_LOGICAL_STEP = "org.eclipse.gemoc.gemoc_modeling_workbench.ui.breakpoint.breakOnLogicalStep";
    public static final String BREAK_ON_MSE_OCCURRENCE = "org.eclipse.gemoc.gemoc_modeling_workbench.ui.breakpoint.breakOnMSE";
    public static final String PROPERTY = "org.eclipse.gemoc.gemoc_modeling_workbench.ui.breakpoint.property";
    private boolean breakOnLogicalStep;
    private boolean breakOnMSE;

    public GemocBreakpoint() {
    }

    public GemocBreakpoint(String identifier, EObject instruction, boolean persistent) throws CoreException {
        super(identifier, instruction, persistent);
        this.setInstructionDefaultBreaks(instruction);
    }

    public boolean getBreakOnLogicalStep() {
        return this.breakOnLogicalStep;
    }

    public boolean getBreakOnMSE() {
        return this.breakOnMSE;
    }

    public void setBreakOnLogicalStep(boolean value) {
        this.breakOnLogicalStep = value;
        try {
            this.getMarker().setAttribute(BREAK_ON_LOGICAL_STEP, (Object)String.valueOf(this.breakOnLogicalStep));
        }
        catch (CoreException e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
    }

    public void setBreakOnMSE(boolean value) {
        this.breakOnMSE = value;
        try {
            this.getMarker().setAttribute(BREAK_ON_MSE_OCCURRENCE, (Object)String.valueOf(this.breakOnMSE));
        }
        catch (CoreException e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
    }

    protected String getMarkerID() {
        return MARKER_ID;
    }

    protected void setMarkerAttibutes(IMarker marker, IFile resource, EObject instruction, boolean persistent) throws CoreException {
        super.setMarkerAttibutes(marker, resource, instruction, persistent);
        this.setInstructionDefaultBreaks(instruction);
        marker.setAttribute(BREAK_ON_LOGICAL_STEP, (Object)String.valueOf(this.breakOnLogicalStep));
        marker.setAttribute(BREAK_ON_MSE_OCCURRENCE, (Object)String.valueOf(this.breakOnMSE));
    }

    private void setInstructionDefaultBreaks(EObject instruction) {
        if (instruction instanceof Step) {
            this.breakOnLogicalStep = true;
            this.breakOnMSE = false;
        } else {
            this.breakOnLogicalStep = false;
            this.breakOnMSE = true;
        }
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.breakOnLogicalStep = Boolean.valueOf((String)marker.getAttribute(BREAK_ON_LOGICAL_STEP));
        this.breakOnMSE = Boolean.valueOf((String)marker.getAttribute(BREAK_ON_MSE_OCCURRENCE));
    }
}

