/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.pde.classpath;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFileUtils;

public class BuildPropertiesHelper {
    public static void addMainJarSourceEntry(IProject project, String newSourceEntryValue, IProgressMonitor monitor) throws CoreException, IOException {
        BuildPropertiesHelper.addJarSourceEntry(project, ".", newSourceEntryValue, monitor);
    }

    public static void addJarSourceEntry(IProject project, String jarName, String newSourceEntryValue, IProgressMonitor monitor) throws CoreException, IOException {
        BuildPropertiesHelper.addEntryInProperty(project, "source." + jarName, newSourceEntryValue, monitor);
    }

    public static void addEntryInProperty(IProject project, String propertyName, String newEntryValue, IProgressMonitor monitor) throws CoreException, IOException {
        Properties properties = new Properties();
        IFile file = project.getFile("build.properties");
        if (file.exists()) {
            properties.load(file.getContents(true));
            String commaSeparatedPropvalues = properties.getProperty(propertyName);
            if (commaSeparatedPropvalues != null) {
                List<String> propValues = Arrays.asList(commaSeparatedPropvalues.split(","));
                for (String srcEntry : propValues) {
                    if (!srcEntry.trim().replaceAll("\\\\", "").equals(newEntryValue)) continue;
                    return;
                }
                String newcommaSeparatedPropvalues = String.valueOf(commaSeparatedPropvalues) + "," + newEntryValue;
                properties.setProperty(propertyName, newcommaSeparatedPropvalues);
            } else {
                properties.setProperty(propertyName, newEntryValue);
            }
        } else {
            properties.setProperty(propertyName, newEntryValue);
        }
        StringWriter writer = new StringWriter();
        properties.store(writer, "");
        IFileUtils.writeInFile((IFile)file, (String)writer.toString(), (IProgressMonitor)monitor);
    }
}

